<?php
/**
 * Package Service Provider Class
 *
 * @version     1.0.$Revision:$
 * @version     SVN: $Id:$
 * @package     bplan-base/global-components
 * @subpackage  Providers
 * @author      Wassilios Meletiadis <wassilios.meletiadis@bplan-solutions.de>
 * @copyright   Copyright (C) 2025 Wassilios Meletiadis <http://www.bplan-solutions.de/>
 * /Δ\
 */

namespace BplanBase\GlobalComponents;


use Illuminate\Support\Facades\File;
use Illuminate\Support\ServiceProvider;


/**
 * Package Service Provider Class
 *
 * @version     1.0.0 / 2025-03-18
 * @author      Wassilios Meletiadis <wassilios.meletiadis@bplan-solutions.de>
 */
class PackageServiceProvider extends ServiceProvider
{


/* +++ TRAITS +++ +++++++++++++++++++++++++++++++++++++++++++++++++++++++++++ */


/* +++ CLASS CONSTANTS +++ ++++++++++++++++++++++++++++++++++++++++++++++++++ */


/* +++ OBJECT MEMBERS +++ +++++++++++++++++++++++++++++++++++++++++++++++++++ */


    /**
     * @var         string $_basePath
     */
    protected $_basePath;


    /**
     * Indicates if loading of the provider is deferred.
     *
     * @var         bool $defer
     */
    protected $defer = false;


/* +++ CLASS MEMBERS +++ ++++++++++++++++++++++++++++++++++++++++++++++++++++ */


/* +++ OBJECT METHODS +++ +++++++++++++++++++++++++++++++++++++++++++++++++++ */


    /**
     *
     * @return 	    array
     *
     * @version     1.0.0 / 2025-03-18
     * @author      Wassilios Meletiadis <wassilios.meletiadis@bplan-solutions.de>
     */
    private function _determineComponents(): array
    {
        /*
        **  Determine Blade components. */
        $basePath = $this->_basePath.'/src/View/Components';

        $components = [];

        if (is_dir($basePath)) {
            foreach (File::allFiles($basePath) as $file) {
                $relativePath = $file->getRelativePathname();
                $components[] = str_replace(
                    ['/', '.php'],
                    ['\\', ''],
                    '\\BplanBase\\GlobalComponents\\View\\Components\\'.$relativePath
                );
            }
        }
        return $components;

    } // _determineComponents()


    /**
     * Bootstrap the application events.
     *
     * @return      void
     *
     * @version     1.0.0 / 2025-03-18
     * @author      Wassilios Meletiadis <wassilios.meletiadis@bplan-solutions.de>
     */
    public function boot(): void
    {
        // /*
        // **  Inform Laravel about translations. */
        // $this->loadTranslationsFrom($this->_basePath.'/lang', 'global-components');
        /*
        **  Inform Laravel about views. */
        $this->loadViewsFrom($this->_basePath.'/resources/views', 'globals');
        /*
        **  Register Laravel components. */
        $this->loadViewComponentsAs('globals', $this->_determineComponents());

        if ($this->app->runningInConsole()) {
            // /*
            // **  Publishes a helper class. */
            // $this->publishes([
            //     $this->_basePath.'/resources/publish/ClassName.php' => app_path('Directory/ClassName.php'),

            //     ], 'class'
            // );
            // /*
            // **  Publishes a configuration file. */
            // $this->publishes([
            //     $this->_basePath.'/config/config-name.php' => config_path('config-name.php'),

            //     ], 'config'
            // );
            // /*
            // **  Publishes all views. */
            // $this->publishes([
            //     $this->_basePath.'/resources/views' => resource_path('views/vendor/package-name'),
            // ]);
            // /*
            // **  Publishes all language files. */
            // $this->publishes([
            //     $this->_basePath.'/lang' => $this->app->langPath('vendor/courier'),
            // ]);
            // /*
            // **  Inform Laravel about migrations. */
            // $this->loadMigrationsFrom($this->_basePath.'/database/migrations');

        }
       // /*
       // **  Load package routes. */
       // $this->loadRoutesFrom($this->_basePath.'/routes/api.php');
       // $this->loadRoutesFrom($this->_basePath.'/routes/web.php');

    } // boot()


    /**
     * Register the service provider.
     *
     * @return      void
     *
     * @version     1.0.0 / 2025-03-18
     * @author      Wassilios Meletiadis <wassilios.meletiadis@bplan-solutions.de>
     */
    public function register(): void
    {
        $this->_basePath = str_replace('\\', '/', realpath(__DIR__.'/..'));
        // /*
        // **  Load the package configuration. */
        // $this->mergeConfigFrom($this->_basePath.'/config/config-name.php', 'config-name');

    } // register()


/* +++ CLASS METHODS +++ ++++++++++++++++++++++++++++++++++++++++++++++++++++ */


} // class PackageServiceProvider extends ServiceProvider {}
