@php
$id = $id ?? md5($attributes->wire('model'));

$maxWidth = [
    'sm' => 'sm:max-w-sm',
    'md' => 'sm:max-w-md',
    'lg' => 'sm:max-w-lg',
    'xl' => 'sm:max-w-xl',
    '2xl' => 'sm:max-w-2xl',
    '3xl' => 'sm:max-w-3xl',
    '4xl' => 'sm:max-w-4xl',
    '5xl' => 'sm:max-w-5xl',
    '6xl' => 'sm:max-w-6xl',
    '7xl' => 'sm:max-w-7xl',
][$attributes['maxWidth'] ?? '2xl'];
@endphp

<div x-data="{{ $name }}" x-cloak x-show="isModalVisible" id="modal{{ ucfirst($name) }}" tabindex="-1"
    {{ $attributes }}
    class="fixed top-0 left-0 right-0 z-50 flex items-center justify-center w-full h-screen overflow-x-hidden overflow-y-auto md:inset-0 md:h-full"
    x-transition:enter="ease-out duration-300" x-transition:enter-start="opacity-0" x-transition:enter-end="opacity-100"
    x-transition:leave="ease-in duration-200" x-transition:leave-start="opacity-100" x-transition:leave-end="opacity-0">
    <div class="fixed inset-0 transition-opacity bg-gray-500 bg-opacity-75"></div>
    <div class="relative w-full {{ $maxWidth }} p-4 max-h-[90vh]">
        <!-- Modal content -->
        <div class="relative p-4 bg-white rounded-lg shadow dark:bg-gray-800 sm:p-5">
            <!-- Modal header -->
            {{ $header }}
            <!-- Modal body -->
            <div>
                {{ $body }}
            </div>
            <div>
                {{ $footer }}
            </div>
        </div>
    </div>

    {{ $alpineScript }}
</div>
