@props(['imageRounded' => true])

<div x-data="{ showList: false, search: '' }" {{ $attributes }}>
    <div class="relative mt-2" x-on:click.away="showList = false">
        <input x-on:keyup="showList = search.trim() != ''" x-model="search"
            @input.debounce.500ms="$wire.filterComboBoxData('{{ $itemsKey }}', search)" id="combobox" type="text"
            placeholder="{{ $placeholder }}"
            class="w-full rounded-md border-0 bg-white py-1.5 pl-3 pr-12 text-gray-900 shadow-sm ring-1 ring-inset ring-gray-300 focus:ring-2 focus:ring-inset focus:ring-primary-600 sm:text-sm sm:leading-6"
            role="combobox" aria-controls="options" aria-expanded="false" />
        <button x-on:click="showList = !showList" type="button"
            class="absolute inset-y-0 right-0 flex items-center px-2 rounded-r-md focus:outline-none">
            <svg class="w-5 h-5 text-gray-400" viewBox="0 0 20 20" fill="currentColor" aria-hidden="true"
                data-slot="icon">
                <path fill-rule="evenodd"
                    d="M10.53 3.47a.75.75 0 0 0-1.06 0L6.22 6.72a.75.75 0 0 0 1.06 1.06L10 5.06l2.72 2.72a.75.75 0 1 0 1.06-1.06l-3.25-3.25Zm-4.31 9.81 3.25 3.25a.75.75 0 0 0 1.06 0l3.25-3.25a.75.75 0 1 0-1.06-1.06L10 14.94l-2.72-2.72a.75.75 0 0 0-1.06 1.06Z"
                    clip-rule="evenodd" />
            </svg>
        </button>

        <ul x-show="showList"
            class="absolute z-10 w-full py-1 mt-1 overflow-auto text-base bg-white rounded-md shadow-lg max-h-60 ring-1 ring-black ring-opacity-5 focus:outline-none sm:text-sm"
            id="options" role="listbox">

            @forelse ($items as $index => $item)
                <li x-data="{ item: @entangle("comboBoxData.$itemsKey.$index") }" @if (isset($multiple) && $multiple === false) x-on:click="showList = false;" @endif
                    wire:click="toggleComboBoxDataItem(@js($itemsKey), @js($index), @js($multiple))"
                    class="relative py-2 pl-3 text-gray-900 cursor-default select-none hover:text-white hover:bg-primary-600 pr-9 group"
                    id="option-0" role="option" tabindex="-1">
                    <div class="flex items-center">
                        @if (!empty($item['image_url']))
                            <img src="{{ $item['image_url'] }}"
                                class="{{ $imageRounded ? 'rounded-full size-8' : 'rounded-none h-8'}}  object-center p-0.5 me-2 shadow bg-white" />
                        @endif

                        <!-- Selected: "font-semibold" -->
                        <span class="truncate">
                            {{ $item['label'] ?? ''}}
                        </span>
                        <!-- Active: "text-primary-200", Not Active: "text-gray-500" -->
                        <span class="ml-2 text-gray-500 truncate group-hover:text-gray-200">
                            {{ $item['tag'] ?? ''}}
                        </span>
                    </div>

                    <span x-show="item?.isSelected"
                        class="absolute inset-y-0 right-0 flex items-center pr-4 text-primary-600 group-hover:text-white">
                        <svg class="w-5 h-5" viewBox="0 0 20 20" fill="currentColor" aria-hidden="true"
                            data-slot="icon">
                            <path fill-rule="evenodd"
                                d="M16.704 4.153a.75.75 0 0 1 .143 1.052l-8 10.5a.75.75 0 0 1-1.127.075l-4.5-4.5a.75.75 0 0 1 1.06-1.06l3.894 3.893 7.48-9.817a.75.75 0 0 1 1.05-.143Z"
                                clip-rule="evenodd" />
                        </svg>
                    </span>
                </li>
                @empty
                <li class="text-gray-400 flex justify-center py-2">
                    @lang('globals::global.select-option.no-options-available')
                </li>
            @endforelse
        </ul>
    </div>
</div>
