<?php
/**
 * Blade Component Class
 *
 * @version     1.0.$Revision:$
 * @version     SVN: $Id:$
 * @package     bplan-base/global-components
 * @subpackage  BladeComponents
 * @author      Emilio Cannarozzo <emilio.cannarozzo@bplan-solutions.de>
 * @copyright   Copyright (C) 2025 bplan-solutions GmbH & Co. KG <http://www.bplan-solutions.de/>
 * /Δ\
 */

namespace BplanBase\GlobalComponents\View\Components\Inputs;


use Closure;
use Illuminate\Contracts\View\View;
use Illuminate\View\Component;


/**
 * Blade Component Class
 *
 * @version     1.1.0 / 2025-03-21
 * @author      Emilio Cannarozzo <emilio.cannarozzo@bplan-solutions.de>
 */
class ComboBox extends Component
{


/* +++ TRAITS +++ +++++++++++++++++++++++++++++++++++++++++++++++++++++++++++ */


/* +++ CLASS CONSTANTS +++ ++++++++++++++++++++++++++++++++++++++++++++++++++ */


/* +++ OBJECT MEMBERS +++ +++++++++++++++++++++++++++++++++++++++++++++++++++ */


/* +++ CLASS MEMBERS +++ ++++++++++++++++++++++++++++++++++++++++++++++++++++ */


/* +++ OBJECT METHODS +++ +++++++++++++++++++++++++++++++++++++++++++++++++++ */


    /**
     * Create a new component instance.
     *
     * @param       ?string $itemsKey
     *
     * @param       ?array $items
     *
     * @param       string $placeholder
     *
     * @param       bool $multiple
     *
     * @author      Emilio Cannarozzo <emilio.cannarozzo@bplan-solutions.de>
     */
    public function __construct(
        public ?string $itemsKey = '',
        public ?array $items = [],
        public string $placeholder = 'Search...',
        public bool $multiple = true,
    )
    {}


    /**
     * Get the view / contents that represent the component.
     *
     * @return      View|Closure|string
     *
     * @author      Emilio Cannarozzo <emilio.cannarozzo@bplan-solutions.de>
     */
    public function render(): View|Closure|string
    {
        return view('global-components::components.inputs.combo-box');
    }


/* +++ CLASS METHODS +++ ++++++++++++++++++++++++++++++++++++++++++++++++++++ */


} // class ComboBox extends Component {}
