<?php
/**
 * Package Service Provider Class
 *
 * @version     1.0.$Revision:$
 * @version     SVN: $Id:$
 * @package     bplan-components/package-name
 * @subpackage  Providers
 * @author      Wassilios Meletiadis <wassilios.meletiadis@bplan-solutions.de>
 * @copyright   Copyright (C) 2025 bplan-solutions GmbH & Co. KG <http://www.bplan-solutions.de/>
 * /Δ\
 */

namespace BplanBase\Globals;


use Illuminate\Support\ServiceProvider;


/**
 * Package Service Provider Class
 *
 * @version     1.0.0 / 2025-03-18
 * @author      Wassilios Meletiadis <wassilios.meletiadis@bplan-solutions.de>
 */
class PackageServiceProvider extends ServiceProvider
{


/* +++ TRAITS +++ +++++++++++++++++++++++++++++++++++++++++++++++++++++++++++ */


/* +++ CLASS CONSTANTS +++ ++++++++++++++++++++++++++++++++++++++++++++++++++ */


/* +++ OBJECT MEMBERS +++ +++++++++++++++++++++++++++++++++++++++++++++++++++ */


    /**
     * @var         string $_basePath
     */
    protected $_basePath;


    /**
     * Indicates if loading of the provider is deferred.
     *
     * @var         bool $defer
     */
    protected $defer = false;


/* +++ CLASS MEMBERS +++ ++++++++++++++++++++++++++++++++++++++++++++++++++++ */


/* +++ OBJECT METHODS +++ +++++++++++++++++++++++++++++++++++++++++++++++++++ */


    /**
     * Bootstrap the application events.
     *
     * @return      void
     *
     * @version     1.0.0 / 2025-03-18
     * @author      Wassilios Meletiadis <wassilios.meletiadis@bplan-solutions.de>
     */
    public function boot(): void
    {
        /*
        **  Inform Laravel about translations. */
        $this->loadTranslationsFrom($this->_basePath.'/lang', 'globals');
        // /*
        // **  Inform Laravel about views. */
        // $this->loadViewsFrom($this->_basePath.'/resources/views', 'package-name');

        if ($this->app->runningInConsole()) {
            // /*
            // **  Publishes a helper class. */
            // $this->publishes([
            //     $this->_basePath.'/resources/publish/ClassName.php' => app_path('Directory/ClassName.php'),

            //     ], 'class'
            // );
            // /*
            // **  Publishes a configuration file. */
            // $this->publishes([
            //     $this->_basePath.'/config/config-name.php' => config_path('config-name.php'),

            //     ], 'config'
            // );
            // /*
            // **  Publishes all views. */
            // $this->publishes([
            //     $this->_basePath.'/resources/views' => resource_path('views/vendor/package-name'),
            // ]);
            // /*
            // **  Publishes all language files. */
            // $this->publishes([
            //     $this->_basePath.'/lang' => $this->app->langPath('vendor/courier'),
            // ]);
            // /*
            // **  Inform Laravel about migrations. */
            // $this->loadMigrationsFrom($this->_basePath.'/database/migrations');

        }
       // /*
       // **  Load package routes. */
       // $this->loadRoutesFrom($this->_basePath.'/routes/api.php');
       // $this->loadRoutesFrom($this->_basePath.'/routes/web.php');

    } // boot()


    /**
     * Register the service provider.
     *
     * @return      void
     *
     * @version     1.0.0 / 2025-03-18
     * @author      Wassilios Meletiadis <wassilios.meletiadis@bplan-solutions.de>
     */
    public function register(): void
    {
        $this->_basePath = str_replace('\\', '/', realpath(__DIR__.'/..'));
        // /*
        // **  Load the package configuration. */
        // $this->mergeConfigFrom($this->_basePath.'/config/config-name.php', 'config-name');

    } // register()


/* +++ CLASS METHODS +++ ++++++++++++++++++++++++++++++++++++++++++++++++++++ */


} // class PackageServiceProvider extends ServiceProvider {}
