<?php
/**
 * Controller Class
 *
 * @version     1.0.$Revision:$
 * @version     SVN: $Id:$
 * @package     bplan-base/globals
 * @subpackage  Controllers
 * @author      Emilio Cannarozzo <emilio.cannarozzo@bplan-solutions.de>
 * @author      Wassilios Meletiadis <wassilios.meletiadis@bplan-solutions.de>
 * @copyright   Copyright (C) 2025 bplan-solutions GmbH & Co. KG <https://www.bplan-solutions.de/>
 * /Δ\
 */

namespace BplanBase\Globals\Http\Controllers;


use BplanBase\Globals\Enums\UserAccessLevel;


/**
 * Controller Class
 *
 * @version     1.0.0 / 2025-04-28
 * @author      Emilio Cannarozzo <emilio.cannarozzo@bplan-solutions.de>
 * @author      Wassilios Meletiadis <wassilios.meletiadis@bplan-solutions.de>
 */
class DemoController extends Controller
{


/* +++ TRAITS +++ +++++++++++++++++++++++++++++++++++++++++++++++++++++++++++ */


/* +++ CLASS CONSTANTS +++ ++++++++++++++++++++++++++++++++++++++++++++++++++ */


/* +++ OBJECT MEMBERS +++ +++++++++++++++++++++++++++++++++++++++++++++++++++ */


/* +++ CLASS MEMBERS +++ ++++++++++++++++++++++++++++++++++++++++++++++++++++ */


/* +++ OBJECT METHODS +++ +++++++++++++++++++++++++++++++++++++++++++++++++++ */


    /**
     *
     * @version     1.0.0 / 2025-04-28
     * @author      Emilio Cannarozzo <emilio.cannarozzo@bplan-solutions.de>
     * @author      Wassilios Meletiadis <wassilios.meletiadis@bplan-solutions.de>
     */
    public function showResetPage()
    {
        if (auth()->user()->hasMinAccessLevel(UserAccessLevel::SystemManager) === false) {
            abort(403);
        }
        if (str_starts_with(strtolower(config('app.env')), 'demo') === false) {
            abort(404);
        }
        return view('globals::containers.demo.reset');

    } // showResetPage()


    /**
     *
     * @version     1.0.0 / 2025-04-28
     * @author      Emilio Cannarozzo <emilio.cannarozzo@bplan-solutions.de>
     * @author      Wassilios Meletiadis <wassilios.meletiadis@bplan-solutions.de>
     */
    public function streamReset()
    {
        if (auth()->user()->hasMinAccessLevel(UserAccessLevel::SystemManager) === false) {
            abort(403);
        }
        if (str_starts_with(strtolower(config('app.env')), 'demo') === false) {
            abort(404);
        }
        return response()->stream(function () {
            /*
            **  Header setzen für SSE. */
            echo 'retry: 1000.'."\n";

            chdir(base_path());

            $handle = popen('php artisan migrate:fresh --seed', 'r');

            if ($handle) {
                while (!feof($handle)) {
                    $line = fgets($handle);

                    echo 'data: '.trim($line)."\n\n";

                    ob_flush();
                    flush();
                }
                pclose($handle);

            } else {
                echo 'data: '.__('globals::demo.error.open-error')."\n\n";
            }
        }, 200, [
            'Cache-Control' => 'no-cache',
            'Content-Type' => 'text/event-stream',
            /*
            **   Für nginx wichtig. */
            'X-Accel-Buffering' => 'no',
        ]);
    } // streamReset()


/* +++ CLASS METHODS +++ ++++++++++++++++++++++++++++++++++++++++++++++++++++ */


} // class DemoController extends Controller {}
