<?php
/**
 * Observer Class
 *
 * @version     1.0.$Revision:$
 * @version     SVN: $Id:$
 * @package     bplan-base/globals
 * @subpackage  Observers
 * @author      Emilio Cannarozzo <emilio.cannarozzo@bplan-solutions.de>
 * @author      Wassilios Meletiadis <wassilios.meletiadis@bplan-solutions.de>
 * @copyright   Copyright (C) 2025 bplan-solutions GmbH & Co. KG <https://www.bplan-solutions.de/>
 * /Δ\
 */

namespace App\Observers;


use App\Models\Setting;
use Illuminate\Support\Str;


/**
 * Observer Class
 *
 * @version     1.1.0 / 2025-05-03
 * @author      Emilio Cannarozzo <emilio.cannarozzo@bplan-solutions.de>
 * @author      Wassilios Meletiadis <wassilios.meletiadis@bplan-solutions.de>
 */
class SettingObserver
{


/* +++ TRAITS +++ +++++++++++++++++++++++++++++++++++++++++++++++++++++++++++ */


/* +++ CLASS CONSTANTS +++ ++++++++++++++++++++++++++++++++++++++++++++++++++ */


    /**
     * @var     string MODEL_CLASS
     */
    const MODEL_CLASS = Setting::class;


/* +++ OBJECT MEMBERS +++ +++++++++++++++++++++++++++++++++++++++++++++++++++ */


/* +++ CLASS MEMBERS +++ ++++++++++++++++++++++++++++++++++++++++++++++++++++ */


/* +++ OBJECT METHODS +++ +++++++++++++++++++++++++++++++++++++++++++++++++++ */


    /**
     * Handle the Models "created" event
     *
     * When a new model is saved for the first time, the creating and created
     * events will dispatch.
     *
     * @param       Setting $Model
     *
     * @return      void
     *
     * @version     1.0.0 / 2025-05-03
     * @author      Emilio Cannarozzo <emilio.cannarozzo@bplan-solutions.de>
     * @author      Wassilios Meletiadis <wassilios.meletiadis@bplan-solutions.de>
     */
    public function created(Setting $Model): void
    {
        //
    } // created()


    /**
     * Handle the Models "creating" event
     *
     * When a new model is saved for the first time, the creating and created
     * events will dispatch.
     *
     * @param       Setting $Model
     *
     * @return      void
     *
     * @version     1.0.0 / 2025-05-03
     * @author      Emilio Cannarozzo <emilio.cannarozzo@bplan-solutions.de>
     * @author      Wassilios Meletiadis <wassilios.meletiadis@bplan-solutions.de>
     */
    public function creating(Setting $Model): void
    {
        $Model->uuid = Str::uuid();

    } // creating()


    /**
     * Handle the Models "deleted" event
     *
     * @param       Setting $Model
     *
     * @return      void
     *
     * @version     1.0.0 / 2025-05-03
     * @author      Emilio Cannarozzo <emilio.cannarozzo@bplan-solutions.de>
     * @author      Wassilios Meletiadis <wassilios.meletiadis@bplan-solutions.de>
     */
    public function deleted(Setting $Model): void
    {
        //
    } // deleted()


    /**
     * Handle the Models "deleting" event
     *
     * @param       Setting $Model
     *
     * @return      void
     *
     * @version     1.0.0 / 2025-05-03
     * @author      Emilio Cannarozzo <emilio.cannarozzo@bplan-solutions.de>
     * @author      Wassilios Meletiadis <wassilios.meletiadis@bplan-solutions.de>
     */
    public function deleting(Setting $Model): void
    {
        //
    } // deleting()


    /**
     * Handle the Models "forceDeleted" event
     *
     * @param       Setting $Model
     *
     * @return      void
     *
     * @version     1.0.0 / 2025-05-03
     * @author      Emilio Cannarozzo <emilio.cannarozzo@bplan-solutions.de>
     * @author      Wassilios Meletiadis <wassilios.meletiadis@bplan-solutions.de>
     */
    public function forceDeleted(Setting $Model): void
    {
        //
    } // forceDeleted()


    /**
     * Handle the Models "forceDeleting" event
     *
     * @param       Setting $Model
     *
     * @return      void
     *
     * @version     1.0.0 / 2025-05-03
     * @author      Emilio Cannarozzo <emilio.cannarozzo@bplan-solutions.de>
     * @author      Wassilios Meletiadis <wassilios.meletiadis@bplan-solutions.de>
     */
    public function forceDeleting(Setting $Model): void
    {
        //
    } // forceDeleting()


    /**
     * Handle the Models "replicating" event
     *
     * @param       Setting $Model
     *
     * @return      void
     *
     * @version     1.0.0 / 2025-05-03
     * @author      Emilio Cannarozzo <emilio.cannarozzo@bplan-solutions.de>
     * @author      Wassilios Meletiadis <wassilios.meletiadis@bplan-solutions.de>
     */
    public function replicating(Setting $Model): void
    {
        //
    } // replicating()


    /**
     * Handle the Models "restored" event
     *
     * @param       Setting $Model
     *
     * @return      void
     *
     * @version     1.0.0 / 2025-05-03
     * @author      Emilio Cannarozzo <emilio.cannarozzo@bplan-solutions.de>
     * @author      Wassilios Meletiadis <wassilios.meletiadis@bplan-solutions.de>
     */
    public function restored(Setting $Model): void
    {
        //
    } // restored()


    /**
     * Handle the Models "restoring" event
     *
     * @param       Setting $Model
     *
     * @return      void
     *
     * @version     1.0.0 / 2025-05-03
     * @author      Emilio Cannarozzo <emilio.cannarozzo@bplan-solutions.de>
     * @author      Wassilios Meletiadis <wassilios.meletiadis@bplan-solutions.de>
     */
    public function restoring(Setting $Model): void
    {
        //
    } // restoring()


    /**
     * Handle the Models "retrieved" event
     *
     * The retrieved event will dispatch when an existing model is retrieved
     * from the database.
     *
     * @param       Setting $Model
     *
     * @return      void
     *
     * @version     1.0.0 / 2025-05-03
     * @author      Emilio Cannarozzo <emilio.cannarozzo@bplan-solutions.de>
     * @author      Wassilios Meletiadis <wassilios.meletiadis@bplan-solutions.de>
     */
    public function retrieved(Setting $Model): void
    {
        //
    } // retrieved()


    /**
     * Handle the Models "saved" event
     *
     * The saving / saved events will dispatch when a model is created or
     * updated - even if the model's attributes have not been changed.
     *
     * @param       Setting $Model
     *
     * @return      void
     *
     * @version     1.0.0 / 2025-05-03
     * @author      Emilio Cannarozzo <emilio.cannarozzo@bplan-solutions.de>
     * @author      Wassilios Meletiadis <wassilios.meletiadis@bplan-solutions.de>
     */
    public function saved(Setting $Model): void
    {
        //
    } // saved()


    /**
     * Handle the Models "saving" event
     *
     * The saving / saved events will dispatch when a model is created or
     * updated - even if the model's attributes have not been changed.
     *
     * @param       Setting $Model
     *
     * @return      void
     *
     * @version     1.0.0 / 2025-05-03
     * @author      Emilio Cannarozzo <emilio.cannarozzo@bplan-solutions.de>
     * @author      Wassilios Meletiadis <wassilios.meletiadis@bplan-solutions.de>
     */
    public function saving(Setting $Model): void
    {
        //
    } // saving()


    /**
     * Handle the Models "trashed" event
     *
     * @param       Setting $Model
     *
     * @return      void
     *
     * @version     1.0.0 / 2025-05-03
     * @author      Emilio Cannarozzo <emilio.cannarozzo@bplan-solutions.de>
     * @author      Wassilios Meletiadis <wassilios.meletiadis@bplan-solutions.de>
     */
    public function trashed(Setting $Model): void
    {
        //
    } // trashed()


    /**
     * Handle the Models "updated" event
     *
     * The updating / updated events will dispatch when an existing model is
     * modified and the save method is called.
     *
     * @param       Setting $Model
     *
     * @return      void
     *
     * @version     1.0.0 / 2025-05-03
     * @author      Emilio Cannarozzo <emilio.cannarozzo@bplan-solutions.de>
     * @author      Wassilios Meletiadis <wassilios.meletiadis@bplan-solutions.de>
     */
    public function updated(Setting $Model): void
    {
        //
    } // updated()


    /**
     * Handle the Models "updating" event
     *
     * The updating / updated events will dispatch when an existing model is
     * modified and the save method is called.
     *
     * @param       Setting $Model
     *
     * @return      void
     *
     * @version     1.0.0 / 2025-05-03
     * @author      Emilio Cannarozzo <emilio.cannarozzo@bplan-solutions.de>
     * @author      Wassilios Meletiadis <wassilios.meletiadis@bplan-solutions.de>
     */
    public function updating(Setting $Model): void
    {
        //
    } // updating()


/* +++ CLASS METHODS +++ ++++++++++++++++++++++++++++++++++++++++++++++++++++ */


} // class SettingObserver {}
