<?php
/**
 * Registry Class
 *
 * @version     1.0.$Revision:$
 * @version     SVN: $Id:$
 * @package     bplan-base/globals
 * @subpackage  Registries
 * @author      Wassilios Meletiadis <wassilios.meletiadis@bplan-solutions.de>
 * @copyright   Copyright (C) 2025 Wassilios Meletiadis <https://www.bplan-solutions.de/>
 * /Δ\
 */

namespace BplanBase\Globals\Registries;


/**
 * Registry Class
 *
 * @version     1.0.0 / 2025-05-17
 * @author      Wassilios Meletiadis <wassilios.meletiadis@bplan-solutions.de>
 */
class SeederRegistry
{

/* +++ CLASS CONSTANTS +++ ++++++++++++++++++++++++++++++++++++++++++++++++++ */


/* +++ OBJECT MEMBERS +++ +++++++++++++++++++++++++++++++++++++++++++++++++++ */


/* +++ CLASS MEMBERS +++ ++++++++++++++++++++++++++++++++++++++++++++++++++++ */


    /**
     * @var     array $_seeders
     */
    private static array $_seeders = [];


/* +++ OBJECT METHODS +++ +++++++++++++++++++++++++++++++++++++++++++++++++++ */


/* +++ CLASS METHODS +++ ++++++++++++++++++++++++++++++++++++++++++++++++++++ */


    /**
     *
     * @return      array
     *
     * @version     1.0.0 / 2025-05-17
     * @author      Wassilios Meletiadis <wassilios.meletiadis@bplan-solutions.de>
     */
    public static function get(): array
    {
        ksort(self::$_seeders);

        return self::$_seeders;

    } // get()


    /**
     *
     * @param       int|string $packageKey
     *
     * @param       string $package
     *
     * @param       string $class
     *
     * @version     1.0.0 / 2025-05-17
     * @author      Wassilios Meletiadis <wassilios.meletiadis@bplan-solutions.de>
     */
    public static function register(int|string $packageKey, string $package, string $class): void
    {
        self::$_seeders[$packageKey] = [
            'class' => $class,
            'package' => $package,
        ];
    } // register()


    /**
     *
     * @param       $Seeder
     *
     * @version     1.0.0 / 2025-05-17
     * @author      Wassilios Meletiadis <wassilios.meletiadis@bplan-solutions.de>
     */
    public static function run($Seeder)
    {
        $seeders = SeederRegistry::get();

        if (!empty($seeders)) {
            echo "\n".'  '
                ."\033[44m"."\033[97m".' INFO '."\033[0m"
                .' Running package seeders.'."\n";

            foreach ($seeders as $packageKey => $seeder) {
                echo "\n".'  Seeding package '.$packageKey.':['.$seeder['package'].'] ';

                $Seeder->call($seeder['class']);

                echo "\033[90m".str_repeat('.', 80 - strlen($seeder['package']))
                    ."\033[92m".' DONE'."\033[0m";
            }
            echo "\n";
        }
    } // run()

} // class SeederRegistry {}
