<?php
/**
 * Migration Class
 *
 * @version     1.0.$Revision:$
 * @version     SVN: $Id:$
 * @package     bplan-base/globals
 * @subpackage  Migrations
 * @author      Wassilios Meletiadis <wassilios.meletiadis@bplan-solutions.de>
 * @copyright   Copyright (C) 2025 bplan-solutions GmbH & Co. KG <https://www.bplan-solutions.de/>
 * /Δ\
 */


use BplanBase\CodeGenerator\Loaders\CodeGenerator;
use BplanBase\Globals\Enums\UserAccessLevel;
use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;


/**
 * Migration Class
 *
 * @author      Wassilios Meletiadis <wassilios.meletiadis@bplan-solutions.de>
 */
return new class extends Migration
{

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::table('users', function (Blueprint $Table) {
            $Table->dropColumn([
                // 'uuid',
                // 'active',
                // 'internal',
                'tenant_id',
            ]);
        });
    } // down()


    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::table('users', function (Blueprint $Table) {
            $Table->text('uuid')->after('id');
            $Table->boolean('active')->after('uuid')->default(1);

            $Table->timestamp('created_at')->after('active');
            $Table->timestamp('updated_at')->after('created_at');
            $Table->softDeletes('deleted_at')->after('updated_at');

            $Table->enum('access_level', array_column(UserAccessLevel::cases(), 'name'))->default('Staff')->after('deleted_at');
            $Table->boolean('internal')->default(0)->after('email_verified_at');
            $Table->boolean('restricted')->default(1)->after('remember_token');

            // $Table->foreignId('tenant_id')->change()->constrained(table: 'tenants', indexName: 'users_FK_tenant_id');
            $Table->foreignId('tenant_id')->constrained(table: 'tenants', indexName: 'users_FK_tenant_id')->after('restricted');

            $Table->index('tenant_id','users_FKI_tenant_id');

            new CodeGenerator($Table, [
                'columns' => [
                    'active' => [
                        'sortable' => true,
                    ],
                    'internal' => [
                        'sortable' => true,
                    ],
                    'tenant_id' => [
                        'sortable' => true,
                    ],
                ],

            ]);

        });
    } // up()

};
