<?php
/**
 * Livewire Component
 *
 * @version     1.0.$Revision:$
 * @version     SVN: $Id:$
 * @generated   2025-04-05 20:20:17
 * @package     bplan-base/globals
 * @subpackage  LivewireComponents
 * @author      Emilio Cannarozzo <emilio.cannarozzo@bplan-solutions.de>
 * @author      Wassilios Meletiadis <wassilios.meletiadis@bplan-solutions.de>
 * @copyright   Copyright (C) 2025 bplan-solutions GmbH & Co. KG <https://www.bplan-solutions.de/>
 * /Δ\
 */

namespace BplanBase\Globals\Livewire\Users\Modals;


use BplanBase\Globals\Enums\LogLevel;
use BplanBase\Globals\Models\Role;
use BplanBase\Globals\Models\RoleUser;
use BplanBase\Globals\Models\User;
use BplanBase\Globals\Notifications\UserCreated;
use BplanBase\Globals\Repositories\RoleRepository;
use BplanBase\Globals\Services\LogService;
use BplanBase\Globals\Services\RoleUserService;
use BplanBase\Globals\Services\UserService;
use Exception;
use Illuminate\Database\Eloquent\Collection;
use Illuminate\Support\Facades\Hash;
use Illuminate\Support\Facades\Log;
use Illuminate\Support\Facades\Notification;
use Illuminate\Support\Str;
use Illuminate\Validation\Rules\Enum;
use Laravel\Jetstream\InteractsWithBanner;
use Livewire\Component;


/**
 * Livewire Component
 *
 * @version     1.0.0 / 2025-04-05
 * @author      Emilio Cannarozzo <emilio.cannarozzo@bplan-solutions.de>
 * @author      Wassilios Meletiadis <wassilios.meletiadis@bplan-solutions.de>
 */
class Add extends Component
{


/* +++ TRAITS +++ +++++++++++++++++++++++++++++++++++++++++++++++++++++++++++ */


    use InteractsWithBanner;


/* +++ CLASS CONSTANTS +++ ++++++++++++++++++++++++++++++++++++++++++++++++++ */


/* +++ OBJECT MEMBERS +++ +++++++++++++++++++++++++++++++++++++++++++++++++++ */


    /**
     * @var
     */
    protected UserService $_Service;


    /**
     * @var
     */
    public string $email;


    /**
     * @var
     */
    protected LogService $logService;


    /**
     * @var
     */
    public string $name;


    /**
     * @var
     */
    public ?Collection $roles;


    /**
     * @var
     */
    public array $selectedRoles;




/* +++ CLASS MEMBERS +++ ++++++++++++++++++++++++++++++++++++++++++++++++++++ */


/* +++ OBJECT METHODS +++ +++++++++++++++++++++++++++++++++++++++++++++++++++ */


    /**
     *
     * @version     1.0.0 / 2025-04-05
     * @author      Emilio Cannarozzo <emilio.cannarozzo@bplan-solutions.de>
     * @author      Wassilios Meletiadis <wassilios.meletiadis@bplan-solutions.de>
     */
    public function addUser()
    {
        $this->validate([
            'name' => 'required',
            'email' => 'required|email:rfc,dns|unique:users,email',
            'selectedRoles' => 'required|min:1',
        ]);

        try
        {
            $UserService = new UserService();

            $newUser = $UserService->create([
                'name' => $this->name,
                'email' => $this->email,
            ]);


            $roleUserService = new RoleUserService();

            foreach ($this->selectedRoles as $roleIndex => $isRoleSelected)
            {
                if($isRoleSelected)
                {
                    $roleUserService->create([
                        'user_id' => $newUser->id,
                        'role_id' => $this->roles[$roleIndex]->id
                    ]);
                }
            }

            $this->logService->log(LogLevel::Info, "User {$this->name} ({$this->email}) created by " . auth()->user()->name . ' (' . auth()->user()->email . ')');

            $this->dispatch('init-tippyjs');
            $this->dispatch('user-created');
        }
        catch (\Throwable $th)
        {
            $this->logService->log(LogLevel::Error, 'Users/Modals/CreateUser add User text: ' . $th->getMessage() . ', file:' . $th->getFile() . ', line:' .  $th->getLine());
            $this->dangerBanner('Error when adding user. Check the logs for more information.');
        }
    } // addUser()


    /**
     *
     * @param       LogService $logService
     *
     * @version     1.0.0 / 2025-04-05
     * @author      Emilio Cannarozzo <emilio.cannarozzo@bplan-solutions.de>
     * @author      Wassilios Meletiadis <wassilios.meletiadis@bplan-solutions.de>
     */
    public function boot(LogService $logService)
    {
        $this->logService = $logService;

    } // boot()


    /**
     *
     * @version     1.0.0 / 2025-04-05
     * @author      Emilio Cannarozzo <emilio.cannarozzo@bplan-solutions.de>
     * @author      Wassilios Meletiadis <wassilios.meletiadis@bplan-solutions.de>
     */
    public function mount()
    {
        $this->roles = RoleRepository::getAll()->keyBy('id');

    } // mount()


    /**
     *
     * @version     1.0.0 / 2025-04-05
     * @author      Emilio Cannarozzo <emilio.cannarozzo@bplan-solutions.de>
     * @author      Wassilios Meletiadis <wassilios.meletiadis@bplan-solutions.de>
     */
    public function render()
    {
        return view('globals::livewire.users.modals.add');

    } // render()


    /**
     *
     * @return      array
     *
     * @version     1.0.0 / 2025-04-05
     * @author      Emilio Cannarozzo <emilio.cannarozzo@bplan-solutions.de>
     * @author      Wassilios Meletiadis <wassilios.meletiadis@bplan-solutions.de>
     */
    public function rules(): array
    {
        $rules = [];

        return $rules;

    } // rules()


    /**
     *
     * @param [type] $isSelected
     * @param [type] $role
     * @return void
     *
     * @version     1.0.0 / 2025-04-05
     * @author      Emilio Cannarozzo <emilio.cannarozzo@bplan-solutions.de>
     * @author      Wassilios Meletiadis <wassilios.meletiadis@bplan-solutions.de>
     */
    public function updatedSelectedRoles($isSelected, $role)
    {
        if(!$isSelected)
        {
            unset($this->selectedRoles[$role]);
        }
    }


/* +++ CLASS METHODS +++ ++++++++++++++++++++++++++++++++++++++++++++++++++++ */


} // class Add extends Component {}
