<?php
/**
 * Observer Class
 *
 * @version     1.0.$Revision:$
 * @version     SVN: $Id:$
 * @generated   2025-04-18 14:13:21
 * @package     bplan-base/globals
 * @subpackage  Observers
 * @author      Emilio Cannarozzo <emilio.cannarozzo@bplan-solutions.de>
 * @author      Wassilios Meletiadis <wassilios.meletiadis@bplan-solutions.de>
 * @copyright   Copyright (C) 2025 bplan-solutions GmbH & Co. KG <https://www.bplan-solutions.de/>
 * /Δ\
 */

namespace BplanBase\Globals\Observers;


use App\Models\User as DerivedUser;
use BplanBase\Globals\Models\User;
use BplanBase\Globals\Notifications\UserCreated;
use BplanBase\Globals\Helpers\StringHelper;
use BplanBase\Globals\Services\RoleUserService;
use Illuminate\Support\Facades\Hash;
use Illuminate\Support\Facades\Log;
use Illuminate\Support\Str;


/**
 * Observer Class
 *
 * @version     1.2.0 / 2025-04-19
 * @author      Emilio Cannarozzo <emilio.cannarozzo@bplan-solutions.de>
 * @author      Wassilios Meletiadis <wassilios.meletiadis@bplan-solutions.de>
 */
class UserObserver
{


/* +++ TRAITS +++ +++++++++++++++++++++++++++++++++++++++++++++++++++++++++++ */


/* +++ CLASS CONSTANTS +++ ++++++++++++++++++++++++++++++++++++++++++++++++++ */


    /**
     * @var     string MODEL_CLASS
     */
    const MODEL_CLASS = User::class;


/* +++ OBJECT MEMBERS +++ +++++++++++++++++++++++++++++++++++++++++++++++++++ */


/* +++ CLASS MEMBERS +++ ++++++++++++++++++++++++++++++++++++++++++++++++++++ */


/* +++ OBJECT METHODS +++ +++++++++++++++++++++++++++++++++++++++++++++++++++ */


    /**
     * Handle the Models "created" event
     *
     * When a new model is saved for the first time, the creating and created
     * events will dispatch.
     *
     * @param       User|DerivedUser $Model
     *
     * @return      void
     *
     * @version     1.1.0 / 2025-04-19
     * @author      Emilio Cannarozzo <emilio.cannarozzo@bplan-solutions.de>
     * @author      Wassilios Meletiadis <wassilios.meletiadis@bplan-solutions.de>
     */
    public function created(User|DerivedUser $Model): void
    {
        /*
        **  Notification an den neuen User senden. */
        $Model->notify(new UserCreated($User->getRandomPassword()));

        $AuthUser = auth()->user();

        if ($AuthUser !== null) {
            Log::info('User '.$Model->name.' '.$Model->email.' created by '.$AuthUser->name.' ('.$AuthUser->email.')');
        }
    } // created()


    /**
     * Handle the Models "creating" event
     *
     * When a new model is saved for the first time, the creating and created
     * events will dispatch.
     *
     * @param       User|DerivedUser $Model
     *
     * @return      void
     *
     * @version     1.0.0 / 2025-04-18
     * @author      Emilio Cannarozzo <emilio.cannarozzo@bplan-solutions.de>
     * @author      Wassilios Meletiadis <wassilios.meletiadis@bplan-solutions.de>
     */
    public function creating(User|DerivedUser $Model): void
    {
        /*
        **  Automatische Werte erzeugen und setzen und Werte bereinigen. */
        $Model->uuid = Str::uuid();
        $Model->password = Hash::make($Model->getRandomPassword());
        $Model->email = StringHelper::normalizeEmail($Model->email);

    } // creating()


    /**
     * Handle the Models "deleted" event
     *
     * @param       User|DerivedUser $Model
     *
     * @return      void
     *
     * @version     1.0.0 / 2025-04-18
     * @author      Emilio Cannarozzo <emilio.cannarozzo@bplan-solutions.de>
     * @author      Wassilios Meletiadis <wassilios.meletiadis@bplan-solutions.de>
     */
    public function deleted(User|DerivedUser $Model): void
    {
        //
    } // deleted()


    /**
     * Handle the Models "deleting" event
     *
     * @param       User|DerivedUser $Model
     *
     * @return      void
     *
     * @version     1.0.0 / 2025-04-18
     * @author      Emilio Cannarozzo <emilio.cannarozzo@bplan-solutions.de>
     * @author      Wassilios Meletiadis <wassilios.meletiadis@bplan-solutions.de>
     */
    public function deleting(User|DerivedUser $Model): void
    {
        with(new RoleUserService())->deleteUserRoles($Model);

    } // deleting()


    /**
     * Handle the Models "forceDeleted" event
     *
     * @param       User|DerivedUser $Model
     *
     * @return      void
     *
     * @version     1.0.0 / 2025-04-18
     * @author      Emilio Cannarozzo <emilio.cannarozzo@bplan-solutions.de>
     * @author      Wassilios Meletiadis <wassilios.meletiadis@bplan-solutions.de>
     */
    public function forceDeleted(User|DerivedUser $Model): void
    {
        //
    } // forceDeleted()


    /**
     * Handle the Models "forceDeleting" event
     *
     * @param       User|DerivedUser $Model
     *
     * @return      void
     *
     * @version     1.0.0 / 2025-04-18
     * @author      Emilio Cannarozzo <emilio.cannarozzo@bplan-solutions.de>
     * @author      Wassilios Meletiadis <wassilios.meletiadis@bplan-solutions.de>
     */
    public function forceDeleting(User|DerivedUser $Model): void
    {
        //
    } // forceDeleting()


    /**
     * Handle the Models "replicating" event
     *
     * @param       User|DerivedUser $Model
     *
     * @return      void
     *
     * @version     1.0.0 / 2025-04-18
     * @author      Emilio Cannarozzo <emilio.cannarozzo@bplan-solutions.de>
     * @author      Wassilios Meletiadis <wassilios.meletiadis@bplan-solutions.de>
     */
    public function replicating(User|DerivedUser $Model): void
    {
        //
    } // replicating()


    /**
     * Handle the Models "restored" event
     *
     * @param       User|DerivedUser $Model
     *
     * @return      void
     *
     * @version     1.0.0 / 2025-04-18
     * @author      Emilio Cannarozzo <emilio.cannarozzo@bplan-solutions.de>
     * @author      Wassilios Meletiadis <wassilios.meletiadis@bplan-solutions.de>
     */
    public function restored(User|DerivedUser $Model): void
    {
        //
    } // restored()


    /**
     * Handle the Models "restoring" event
     *
     * @param       User|DerivedUser $Model
     *
     * @return      void
     *
     * @version     1.0.0 / 2025-04-18
     * @author      Emilio Cannarozzo <emilio.cannarozzo@bplan-solutions.de>
     * @author      Wassilios Meletiadis <wassilios.meletiadis@bplan-solutions.de>
     */
    public function restoring(User|DerivedUser $Model): void
    {
        //
    } // restoring()


    /**
     * Handle the Models "retrieved" event
     *
     * The retrieved event will dispatch when an existing model is retrieved
     * from the database.
     *
     * @param       User|DerivedUser $Model
     *
     * @return      void
     *
     * @version     1.0.0 / 2025-04-18
     * @author      Emilio Cannarozzo <emilio.cannarozzo@bplan-solutions.de>
     * @author      Wassilios Meletiadis <wassilios.meletiadis@bplan-solutions.de>
     */
    public function retrieved(User|DerivedUser $Model): void
    {
        //
    } // retrieved()


    /**
     * Handle the Models "saved" event
     *
     * The saving / saved events will dispatch when a model is created or
     * updated - even if the model's attributes have not been changed.
     *
     * @param       User|DerivedUser $Model
     *
     * @return      void
     *
     * @version     1.0.0 / 2025-04-18
     * @author      Emilio Cannarozzo <emilio.cannarozzo@bplan-solutions.de>
     * @author      Wassilios Meletiadis <wassilios.meletiadis@bplan-solutions.de>
     */
    public function saved(User|DerivedUser $Model): void
    {
        //
    } // saved()


    /**
     * Handle the Models "saving" event
     *
     * The saving / saved events will dispatch when a model is created or
     * updated - even if the model's attributes have not been changed.
     *
     * @param       User|DerivedUser $Model
     *
     * @return      void
     *
     * @version     1.0.0 / 2025-04-18
     * @author      Emilio Cannarozzo <emilio.cannarozzo@bplan-solutions.de>
     * @author      Wassilios Meletiadis <wassilios.meletiadis@bplan-solutions.de>
     */
    public function saving(User|DerivedUser $Model): void
    {
        //
    } // saving()


    /**
     * Handle the Models "trashed" event
     *
     * @param       User|DerivedUser $Model
     *
     * @return      void
     *
     * @version     1.0.0 / 2025-04-18
     * @author      Emilio Cannarozzo <emilio.cannarozzo@bplan-solutions.de>
     * @author      Wassilios Meletiadis <wassilios.meletiadis@bplan-solutions.de>
     */
    public function trashed(User|DerivedUser $Model): void
    {
        //
    } // trashed()


    /**
     * Handle the Models "updated" event
     *
     * The updating / updated events will dispatch when an existing model is
     * modified and the save method is called.
     *
     * @param       User|DerivedUser $Model
     *
     * @return      void
     *
     * @version     1.0.0 / 2025-04-18
     * @author      Emilio Cannarozzo <emilio.cannarozzo@bplan-solutions.de>
     * @author      Wassilios Meletiadis <wassilios.meletiadis@bplan-solutions.de>
     */
    public function updated(User|DerivedUser $Model): void
    {
        //
    } // updated()


    /**
     * Handle the Models "updating" event
     *
     * The updating / updated events will dispatch when an existing model is
     * modified and the save method is called.
     *
     * @param       User|DerivedUser $Model
     *
     * @return      void
     *
     * @version     1.0.0 / 2025-04-18
     * @author      Emilio Cannarozzo <emilio.cannarozzo@bplan-solutions.de>
     * @author      Wassilios Meletiadis <wassilios.meletiadis@bplan-solutions.de>
     */
    public function updating(User|DerivedUser $Model): void
    {
        /*
        **  Werte bereinigen. */
        $Model->email = StringHelper::normalizeEmail($Model->email);

    } // updating()


/* +++ CLASS METHODS +++ ++++++++++++++++++++++++++++++++++++++++++++++++++++ */


} // class UserObserver {}
