{{--
 *
 * @version     1.0.$Revision:$
 * @version     SVN: $Id:$
 * @package     bplan-base/globals
 * @subpackage  Templates
 * @author      Wassilios Meletiadis <wassilios.meletiadis@bplan-solutions.de>
 * @copyright   Copyright (C) 2025 Wassilios Meletiadis <https://www.bplan-solutions.de/>
 * /Δ\
--}}

{{--

 @var       Model $MainObject

 @var       string $modelClass

 @var       string $resourceGroup

 @var       string $resourceName

 @var       string $serviceClass

--}}

@php

if (!isset($resourceGroup)) {
    $resourceGroup = $resourceName;

    $params = [
        'Collection' => $Collection,
        'modelClass' => $modelClass ?? null,
        'resourceGroup' => $resourceGroup,
        'resourceName' => $resourceName,
        'serviceClass' => $serviceClass,
    ];
    $key = 'grid-'.now()->timestamp.'-'.$resourceName;

}

@endphp

    <x-app-layout>

      <x-slot name="header">
        <h2 class="font-semibold text-xl text-gray-800 leading-tight">
            {{ __('globals::core-'.$resourceGroup.'.page.heading', ['resourcename' => ucwords($resourceName)]) }}
        </h2>
      </x-slot>

      <div class="py-12">
        <div class="max-w-7xl mx-auto sm:px-6 lg:px-8">
          <div class="bg-white overflow-hidden shadow-xl sm:rounded-lg">

@livewire($componentClass, $params, $key)

          </div>
        </div>
      </div>

    </x-app-layout>
