<?php
/**
 * Create Action Class
 *
 * @version     1.0.$Revision:$
 * @version     SVN: $Id:$
 * @generated   2025-05-19 22:39:22
 * @package     bplan-base/globals
 * @subpackage  Actions
 * @author      Emilio Cannarozzo <emilio.cannarozzo@bplan-solutions.de>
 * @author      Wassilios Meletiadis <wassilios.meletiadis@bplan-solutions.de>
 * @copyright   Copyright (C) 2025 bplan-solutions GmbH & Co. KG <https://www.bplan-solutions.de/>
 * /Δ\
 */

namespace BplanBase\Globals\Actions\TenantRecord;


use App\Models\Tenant as DerivedTenant;
use App\Models\TenantRecord as DerivedTenantRecord;
use BplanBase\Globals\Models\Tenant;
use BplanBase\Globals\Models\TenantRecord;


/**
 * Create Action Class
 *
 * @version     1.3.0 / 2025-05-27
 * @author      Emilio Cannarozzo <emilio.cannarozzo@bplan-solutions.de>
 * @author      Wassilios Meletiadis <wassilios.meletiadis@bplan-solutions.de>
 */
class Create
{


/* +++ TRAITS +++ +++++++++++++++++++++++++++++++++++++++++++++++++++++++++++ */


/* +++ CLASS CONSTANTS +++ ++++++++++++++++++++++++++++++++++++++++++++++++++ */


/* +++ OBJECT MEMBERS +++ +++++++++++++++++++++++++++++++++++++++++++++++++++ */


/* +++ CLASS MEMBERS +++ ++++++++++++++++++++++++++++++++++++++++++++++++++++ */


/* +++ OBJECT METHODS +++ +++++++++++++++++++++++++++++++++++++++++++++++++++ */


    /**
     *
     * @param       Tenant|DerivedTenant $Tenant
     *
     * @return      TenantRecord|DerivedTenantRecord
     *
     * @version     4.0.0 / 2025-05-27
     * @author      Emilio Cannarozzo <emilio.cannarozzo@bplan-solutions.de>
     * @author      Wassilios Meletiadis <wassilios.meletiadis@bplan-solutions.de>
     */
    public function execute(Tenant|DerivedTenant $Tenant): TenantRecord|DerivedTenantRecord
    {
        /*
        **  Korrespondierenden TenantRecord-Objekt erstellen. */
        if ($Tenant instanceof DerivedTenant) {
            $Model = new DerivedTenantRecord();
        } else {
            $Model = new TenantRecord();
        }
        /*
        **  ID, UUID und der Name für "company" werden vom Tenant übernommen.
        **  "company" ist in der Folge aber unabhängig vom Identifier des Tenants
        **  und kann beliebig geändert werden. */
        $Model->id = $Tenant->id;
        $Model->uuid = $Tenant->uuid;
        $Model->active = $Tenant->active;
        $Model->company = $Tenant->identifier;

        $Model->save();

        return $Model;

    } // execute()


/* +++ CLASS METHODS +++ ++++++++++++++++++++++++++++++++++++++++++++++++++++ */


} // class Create {}
