<?php
/**
 * Admin Controller Class
 *
 * @version     1.0.$Revision:$
 * @version     SVN: $Id:$
 * @package     bplan-base/globals
 * @subpackage  Controllers
 * @author      Wassilios Meletiadis <wassilios.meletiadis@bplan-solutions.de>
 * @copyright   Copyright (C) 2025 Wassilios Meletiadis <https://www.bplan-solutions.de/>
 * /Δ\
 */

namespace BplanBase\Globals\Http\Controllers\Core;


use BplanBase\Globals\Livewire\Core\EntityTypeFieldDefinitions\Form as EntityTypeFieldDefinitionForm;
use BplanBase\Globals\Livewire\Core\EntityTypeFieldDefinitions\Grid as EntityTypeFieldDefinitionGrid;
use BplanBase\Globals\Models\FieldDefinition;
use BplanBase\Globals\Repositories\FieldDefinitionRepository;
use BplanBase\Globals\Services\FieldDefinitionService;
use Illuminate\Http\Request;


/**
 * Admin Controller Class
 *
 * @version     1.0.0 / 2025-05-25
 * @author      Wassilios Meletiadis <wassilios.meletiadis@bplan-solutions.de>
 */
class FieldDefinitionController extends BaseController
{

/* +++ TRAITS +++ +++++++++++++++++++++++++++++++++++++++++++++++++++++++++++ */


/* +++ CLASS CONSTANTS +++ ++++++++++++++++++++++++++++++++++++++++++++++++++ */


/* +++ OBJECT MEMBERS +++ +++++++++++++++++++++++++++++++++++++++++++++++++++ */


    /**
     * @var     string $_modelClass
     */
    protected string $_formClass = EntityTypeFieldDefinitionForm::class;


    /**
     * @var     string $_modelClass
     */
    protected string $_gridClass = EntityTypeFieldDefinitionGrid::class;


    /**
     * @var     string $_modelClass
     */
    protected string $_modelClass = EntityTypeFieldDefinition::class;


    /**
     * @var     string $_repositoryClass
     */
    protected string $_repositoryClass = EntityTypeFieldDefinitionRepository::class;


    /**
     * @var     string $_resourceName
     */
    protected string $_resourceName = 'field-definitions';


/* +++ CLASS MEMBERS +++ ++++++++++++++++++++++++++++++++++++++++++++++++++++ */


/* +++ OBJECT METHODS +++ +++++++++++++++++++++++++++++++++++++++++++++++++++ */


    /**
     *
     * @param       Request $Request
     *
     * @param       EntityTypeFieldDefinitionService $Service
     *
     * @version     1.0.0 / 2025-05-25
     * @author      Wassilios Meletiadis <wassilios.meletiadis@bplan-solutions.de>
     */
    public function __construct(Request $Request, EntityTypeFieldDefinitionService $Service)
    {
        parent::__construct($Request, $Service);

    } // __construct()


    /**
     * Show the form for editing the specified resource.
     *
     * @return      \Illuminate\Http\Response
     *
     * @version     1.0.0 / 2025-05-25
     * @author      Wassilios Meletiadis <wassilios.meletiadis@bplan-solutions.de>
     */
    public function index()
    {
        return view('livewire.grid-container', [
            'Collection' => null,
            'modelClass' => $this->_modelClass,
            'resourceName' => $this->_resourceName,
            'serviceClass' => $this->_Service::class,
        ]);
    } // index()


/* +++ CLASS METHODS +++ ++++++++++++++++++++++++++++++++++++++++++++++++++++ */


} // class EntityTypeFieldDefinitionController extends BaseController {}
