<?php
/**
 *
 * @version     1.0.$Revision:$
 * @version     SVN: $Id:$
 * @package     bplan-base/globals
 * @subpackage  LivewireComponents
 * @author      Wassilios Meletiadis <wassilios.meletiadis@bplan-solutions.de>
 * @copyright   Copyright (C) 2025 Wassilios Meletiadis <https://www.bplan-solutions.de/>
 * /Δ\
 */

namespace BplanBase\Globals\Livewire\Core\ExternalSystems;


use BplanBase\Globals\Enums\ExternalSystemType;
use BplanBase\Globals\Livewire\Core\Global\BaseForm;
use Exception;
use Illuminate\Support\Str;
use Livewire\Component;


/**
 *
 * @version     1.0.0 / 2025-05-25
 * @author      Wassilios Meletiadis <wassilios.meletiadis@bplan-solutions.de>
 */
class Form extends BaseForm
{


/* +++ TRAITS +++ +++++++++++++++++++++++++++++++++++++++++++++++++++++++++++ */


/* +++ CLASS CONSTANTS +++ ++++++++++++++++++++++++++++++++++++++++++++++++++ */


/* +++ OBJECT MEMBERS +++ +++++++++++++++++++++++++++++++++++++++++++++++++++ */


    /**
     * @var     integer $configSettingRows
     */
    public $configSettingRows = 30;


    /**
     * @var     string $configTemplate
     */
    public $configTemplate;


    /**
     * @var         array $main
     * @version     1.0.0 / 2025-05-25
     */
    public $main = [
        'active'     => true,
        //'config_template' => null,
        'description' => null,
        'identifier' => null,
        'label' => null,
        'system_type' => null,
    ];


    /**
     * @var     array $systemTypes
     */
    public $systemTypes;


    /**
     * @var    array $tabs
     */
    public $tabs = [
        'base',
        'config-template',
    ];


/* +++ CLASS MEMBERS +++ ++++++++++++++++++++++++++++++++++++++++++++++++++++ */


/* +++ OBJECT METHODS +++ +++++++++++++++++++++++++++++++++++++++++++++++++++ */


    /**
     *
     * @version     1.0.0 / 2025-05-25
     * @author      Wassilios Meletiadis <wassilios.meletiadis@bplan-solutions.de>
     */
    protected function _initConfigTemplate(): void
    {
        if (!empty($this->main['configTemplate'])) {
            $configTemplate = json_decode($this->main['configTemplate']);
            $configTemplate = (array) $configTemplate;


            if (key($configTemplate) === '.meta') {
                next($configTemplate);
            }
            $itemCount = count((array) current($configTemplate));
            /*
            **  Anzahl der Element + 2 für die Schlüssel- und die abschließende Klammerzeile des
            **  Elements + 2 für die Klammerzeilen des Objekts. */
            $this->configSettingRows = count($configTemplate) * ($itemCount + 2) + 2;
            /*
            **  Pauschal noch ein paar mehr Zeilen hinzufügen, wenn es ein .meta-Element gibt. */
            if (isset($configTemplate['.meta'])) {
                $this->configSettingRows += 40;
            }
            $this->configTemplate = json_encode($configTemplate, JSON_PRETTY_PRINT | JSON_UNESCAPED_UNICODE);
        }
    } // _initconfigTemplate()


    /**
     *
     * @version     1.0.0 / 2025-05-25
     * @author      Wassilios Meletiadis <wassilios.meletiadis@bplan-solutions.de>
     */
    protected function _initSystemTypes(): void
    {
        $cases = ExternalSystemType::cases();

        $this->systemTypes = array_combine(array_column($cases, 'name'), array_column($cases, 'value'));

    } // _initSystemTypes()


    /**
     *
     * @todo        Hier muss noch abgefangen werden, dass bei nummerischer Indizierung immer
     *              zwingend ein name-Attribut angegeben sein muss.
     *
     * @throws      Exception
     *
     * @version     1.0.0 / 2025-05-25
     * @author      Wassilios Meletiadis <wassilios.meletiadis@bplan-solutions.de>
     */
    protected function _onBeforeValidation(): void
    {
        parent::_onBeforeValidation();

        $this->configTemplate = trim($this->configTemplate);

        $configTemplate = null;

        if (!empty($this->configTemplate)) {
            $configTemplate = json_decode($this->configTemplate);
            /*
            **  json_decode() liefert NULL, wenn es sich bei der Eingabe nicht um einen gültigen
            **  JSON-String gehandelt hat. */
            if ($configTemplate === null) {
                throw new Exception(__('validation.json', ['attribute' => '[configTemplate]']));
            }
            $this->main['configTemplate'] = json_encode($configTemplate);

        } else {
            $this->main['configTemplate'] = null;
        }
    } // _onBeforeValidation()


    /**
     * Überschreibt die gleichnamige Methode der Base-Klasse
     *
     * @version     1.0.0 / 2025-05-25
     * @author      Wassilios Meletiadis <wassilios.meletiadis@bplan-solutions.de>
     */
    public function mount(): void
    {
        parent::mount();

        $this->_initSystemTypes();

        if ($this->exists === true) {
            $this->_initconfigTemplate();
        }
    } // mount()


/* +++ CLASS METHODS +++ ++++++++++++++++++++++++++++++++++++++++++++++++++++ */


} // class Form extends BaseForm {}
