<?php
/**
 * Repository Class
 *
 * @version     1.0.$Revision:$
 * @version     SVN: $Id:$
 * @generated   2025-05-18 20:00:27
 * @package     bplan-base/globals
 * @subpackage  Repositories
 * @author      Emilio Cannarozzo <emilio.cannarozzo@bplan-solutions.de>
 * @author      Wassilios Meletiadis <wassilios.meletiadis@bplan-solutions.de>
 * @copyright   Copyright (C) 2025 bplan-solutions GmbH & Co. KG <https://www.bplan-solutions.de/>
 * /Δ\
 */

namespace BplanBase\Globals\Repositories;


use App\Models\TenantLocale as DerivedTenantLocale;
use BplanBase\Globals\Models\TenantLocale;
use Illuminate\Database\Eloquent\Collection;


/**
 * Repository Class
 *
 * @version     3.1.0 / 2025-05-25
 * @author      Emilio Cannarozzo <emilio.cannarozzo@bplan-solutions.de>
 * @author      Wassilios Meletiadis <wassilios.meletiadis@bplan-solutions.de>
 */
class TenantLocaleRepository
{


/* +++ TRAITS +++ +++++++++++++++++++++++++++++++++++++++++++++++++++++++++++ */


/* +++ CLASS CONSTANTS +++ ++++++++++++++++++++++++++++++++++++++++++++++++++ */


/* +++ OBJECT MEMBERS +++ +++++++++++++++++++++++++++++++++++++++++++++++++++ */


/* +++ CLASS MEMBERS +++ ++++++++++++++++++++++++++++++++++++++++++++++++++++ */


    /**
     * @var     string $_modelClass
     */
    protected static $_modelClass = \BplanBase\Globals\Models\TenantLocale::class;


/* +++ OBJECT METHODS +++ +++++++++++++++++++++++++++++++++++++++++++++++++++ */


/* +++ CLASS METHODS +++ ++++++++++++++++++++++++++++++++++++++++++++++++++++ */


    /**
     * Liefert einen Array mit den Locales des Mandanten
     *
     * Die Methode sucht, ausgehend vom übergebenen Tenant, solange bis bei beim Tenant selbst oder
     * irgendeinem der Master-Tenants Locales gefunden wurden.
     * Der Ergebnis-Array verwendet den KeyIndex der Locales als Schlüssel.
     *
     * @param       string $tenantId
     *
     * @param       bool $withInactive
     *
     * @return      array
     *
     * @version     1.0.0 / 2025-05-20
     * @author      Wassilios Meletiadis <wassilios.meletiadis@bplan-solutions.de>
     */
    public static function determineTenantLocales(string $tenantId, bool $withInactive = false): array|null
    {
        static $cache = [];

        $cacheKey = md5(serialize(func_get_args()));

        if (isset($cache[$cacheKey])) {
            return $cache[$cacheKey];
        }
        $LocaleCollection = self::getTenantLocales($tenantId, $withInactive);

        if ($LocaleCollection->isEmpty() === false) {
            $locales = [];

            foreach ($LocaleCollection as $TenantLocale) {
                $index = $TenantLocale->key_index;
                $locale = $TenantLocale->locale;

                $locales[$index] = $locale;
            }
            return $cache[$cacheKey] = $locales;
        }
        $Tenant = TenantRepository::getById($tenantId, ignoreRestriction: true);

        if ($Tenant->master_id !== null) {
            return $cache[$cacheKey] = self::determineTenantLocales($Tenant->master_id, $withInactive);
        }
        return null;
        /*
            @todo   Exception werfen.
                    Dieser Fall dürfte eigentlich nie eintreten, weil zumindest der System-Tenant
                    immer Locales haben sollte. Wenn er doch eintritt, dann ist schon bei der
                    Einrichtung des Systems etwas schiefgelaufen.
        */

    } // determineTenantLocales()


    /**
     * Returns a collection of models
     *
     * @param       bool $ignoreCache
     *              Controls the use of the method cache when determining the result.
     *              If TRUE is passed, a database access is carried out even if the
     *              method cache already contains a suitable entry. The storage of
     *              a value in the method cache is not affected by this parameter.
     *
     * @param       array|string|null $orderBy
     *              @see BplanBase\Globals\Helpers\QueryHelper::applyOrderBy() for
     *              details.
     *
     * @param       bool $withInactive
     *              By default, only the active data records are returned. By
     *              setting this parameter to TRUE, the inactive data records can
     *              also be read out.
     *
     * @return      Collection
     *
     * @version     2.0.0 / 2025-05-25
     * @author      Emilio Cannarozzo <emilio.cannarozzo@bplan-solutions.de>
     * @author      Wassilios Meletiadis <wassilios.meletiadis@bplan-solutions.de>
     */
    public static function getAll(bool $ignoreCache = false, array|string|null $orderBy = null, bool $withInactive = false): Collection
    {
        static $cache = [];

        $cacheKey = md5(serialize(func_get_args()));

        if ($ignoreCache === false && isset($cache[$cacheKey])) {
            return $cache[$cacheKey];
        }
        $Query = static::$_modelClass::query();

        if ($withInactive === false) {
            $Query->active();
        }
        $Query->ordered($orderBy);

        return $cache[$cacheKey] = $Query->get();

    } // getAll()


    /**
     * Returns the model instance for the given ID
     *
     * @param       int|string $id
     *
     * @param       bool $ignoreCache
     *              Controls the use of the method cache when determining the result.
     *              If TRUE is passed, a database access is carried out even if the method cache
     *              already contains a suitable entry. The storage of a value in the method cache
     *              is not affected by this parameter.
     *
     * @param       bool $returnOrFail
     *              Controls the return of the method.
     *              If no suitable entry can be found in the database, either NULL is returned (TRUE)
     *              or an exception is thrown (FALSE). This allows the result of the method call to
     *              be used directly in the Api controller.
     *
     * @throws      Illuminate\Database\Eloquent\ModelNotFoundException
     *
     * @return      TenantLocale|DerivedTenantLocale|null
     *
     * @version     2.0.0 / 2025-05-18
     * @author      Emilio Cannarozzo <emilio.cannarozzo@bplan-solutions.de>
     * @author      Wassilios Meletiadis <wassilios.meletiadis@bplan-solutions.de>
     */
    public static function getById(int|string $id, bool $ignoreCache = false, bool $returnOrFail = true): TenantLocale|DerivedTenantLocale|null
    {
        static $cache = [];

        $cacheKey = md5(serialize(func_get_args()));

        if ($ignoreCache === false && isset($cache[$cacheKey])) {
            return $cache[$cacheKey];
        }
        $Query = static::$_modelClass::query();

        if ($returnOrFail === true) {
            return $cache[$cacheKey] = $Query->find($id);
        }
        return $cache[$cacheKey] = $Query->findOrFail($id);

    } // getById()


    /**
     * Returns the model instance for the given UUID
     *
     * @param       string $uuid
     *
     * @param       bool $ignoreCache
     *              Controls the use of the method cache when determining the result.
     *              If TRUE is passed, a database access is carried out even if the method cache
     *              already contains a suitable entry. The storage of a value in the method cache
     *              is not affected by this parameter.
     *
     * @param       bool $returnOrFail
     *              Controls the return of the method.
     *              If no suitable entry can be found in the database, either NULL is returned (TRUE)
     *              or an exception is thrown (FALSE). This allows the result of the method call to
     *              be used directly in the Api controller.
     *
     * @throws      Illuminate\Database\Eloquent\ModelNotFoundException
     *
     * @return      TenantLocale|DerivedTenantLocale|null
     *
     * @version     1.0.0 / 2025-05-18
     * @author      Emilio Cannarozzo <emilio.cannarozzo@bplan-solutions.de>
     * @author      Wassilios Meletiadis <wassilios.meletiadis@bplan-solutions.de>
     */
    public static function getByUuid(int|string $uuid, bool $ignoreCache = false, bool $returnOrFail = true): TenantLocale|DerivedTenantLocale|null
    {
        static $cache = [];

        $cacheKey = md5(serialize(func_get_args()));

        if ($ignoreCache === false && isset($cache[$cacheKey])) {
            return $cache[$cacheKey];
        }
        $Query = static::$_modelClass::where('uuid', '=', $uuid);

        if ($returnOrFail === true) {
            return $cache[$cacheKey] = $Query->first();
        }
        return $cache[$cacheKey] = $Query->firstOrFail();

    } // getByUuid()


    /**
     * Returns the Id for the given UUID
     *
     * @param       string $uuid
     *
     * @param       bool $ignoreCache
     *              Controls the use of the method cache when determining the result.
     *              If TRUE is passed, a database access is carried out even if the method cache
     *              already contains a suitable entry. The storage of a value in the method cache
     *              is not affected by this parameter.
     *
     * @param       bool $returnOrFail
     *              Controls the return of the method.
     *              If no suitable entry can be found in the database, either NULL is returned (TRUE)
     *              or an exception is thrown (FALSE). This allows the result of the method call to
     *              be used directly in the Api controller.
     *
     * @throws      Illuminate\Database\Eloquent\ModelNotFoundException
     *
     * @return      int|null
     *
     * @version     2.0.0 / 2025-05-25
     * @author      Emilio Cannarozzo <emilio.cannarozzo@bplan-solutions.de>
     * @author      Wassilios Meletiadis <wassilios.meletiadis@bplan-solutions.de>
     */
    public static function getIdByUuid(string $uuid, bool $ignoreCache = false, bool $returnOrFail = true): int|null
    {
        static $cache = [];

        $cacheKey = md5(serialize(func_get_args()));

        if ($ignoreCache === false && isset($cache[$cacheKey])) {
            return $cache[$cacheKey];
        }
        $Query = static::$_modelClass::select('id')
            ->where('uuid', '=', $uuid);

        if ($returnOrFail === true) {
            $Model = $Query->first();

            if ($Model === null) {
                return null;
            }
            return $cache[$cacheKey] = $Model->id;
        }
        $Model = $Query->firstOrFail();

        return $cache[$cacheKey] = $Model->id;

    } // getIdByUuid()


    /**
     * Liefert den aktuell höchsten Wert für die SortSequence in einer Gruppe von Auswahlwerten
     *
     * @param       int|string $tenantId
     *              Optional kann die ID eines Mandanten übergeben werden. Wenn der Parameter nicht
     *              verwendet wurd, dann wird die ID des Mandanten verwendet, über den der Zugriff
     *              auf die Api erfolgte.
     *
     * @param       bool $getNext
     *              Wird dieser Parameter auf TRUE gesetzt, dann wird anstelle des aktuell höchsten
     *              Werts der nächsthöhere Wert geliefert wird. Dabei wird nicht einfach nur 1 zum
     *              ermittelten Wert addiert, sondern es wird auch dafür gesorgt, dass die
     *              Nachkommastelle 0 ist.
     *
     * @return      float
     *
     * @version     1.0.0 / 2025-05-20
     * @author      Wassilios Meletiadis <wassilios.meletiadis@bplan-solutions.de>
     */
    public static function getMaxKeyIndex(int|string $tenant_id, bool $getNext = false): float
    {
        $max = (int) static::$_modelClass::select('id')
            ->where('tenant_id', '=', $tenantId)
            ->max('key_index');

        if ($getNext === true) {
            $max++;
        }
        return $max;

    } // getMaxKeyIndex()


    /**
     * Liefert eine Collection mit den Locales des Mandanten
     *
     * Die Collection ist so sortiert, dass die Haupt-Locale an erster Stelle steht.
     *
     * @param       null|string $tenantId
     *
     * @param       bool $withInactive
     *
     * @return      array
     *
     * @version     1.0.0 / 2025-05-20
     * @author      Wassilios Meletiadis <wassilios.meletiadis@bplan-solutions.de>
     */
    public static function getTenantLocales(null|string $tenantId = null, bool $withInactive = false): Collection
    {
        static $cache = [];

        $cacheKey = md5(serialize(func_get_args()));

        if (isset($cache[$cacheKey])) {
            return $cache[$cacheKey];
        }
        $Query = TenantLocale::where('tenant_id', '=', $tenantId);

        if ($withInactive === false) {
            $Query->where('active', '=', 1);
        }
        $Query->orderBy('key_index');

        return $cache[$cacheKey] = $Query->get();

    } // getTenantLocales()


} // class TenantLocaleRepository {}
