<?php
/**
 * Service Class
 *
 * @version     1.0.$Revision:$
 * @version     SVN: $Id:$
 * @generated   2025-05-03 23:52:09
 * @package     bplan-base/globals
 * @subpackage  Services
 * @author      Emilio Cannarozzo <emilio.cannarozzo@bplan-solutions.de>
 * @author      Wassilios Meletiadis <wassilios.meletiadis@bplan-solutions.de>
 * @copyright   Copyright (C) 2025 bplan-solutions GmbH & Co. KG <https://www.bplan-solutions.de/>
 * /Δ\
 */

namespace BplanBase\Globals\Services;


use App\Models\User as DerivedUser;
use BplanBase\Globals\Actions\User\Create;
use BplanBase\Globals\Actions\User\Delete;
use BplanBase\Globals\Actions\User\ResetPassword;
use BplanBase\Globals\Actions\User\Update;
use BplanBase\Globals\Models\User;


/**
 * Service Class
 *
 * @version     2.0.0 / 2025-05-03
 * @author      Emilio Cannarozzo <emilio.cannarozzo@bplan-solutions.de>
 * @author      Wassilios Meletiadis <wassilios.meletiadis@bplan-solutions.de>
 */
class UserService
{

/* +++ TRAITS +++ +++++++++++++++++++++++++++++++++++++++++++++++++++++++++++ */


/* +++ CLASS CONSTANTS +++ ++++++++++++++++++++++++++++++++++++++++++++++++++ */


/* +++ OBJECT MEMBERS +++ +++++++++++++++++++++++++++++++++++++++++++++++++++ */


/* +++ CLASS MEMBERS +++ ++++++++++++++++++++++++++++++++++++++++++++++++++++ */


/* +++ OBJECT METHODS +++ +++++++++++++++++++++++++++++++++++++++++++++++++++ */


    /**
     *
     * @param       array $attributes
     *
     * @return      User|DerivedUser
     *
     * @version     1.0.0 / 2025-05-03
     * @author      Emilio Cannarozzo <emilio.cannarozzo@bplan-solutions.de>
     * @author      Wassilios Meletiadis <wassilios.meletiadis@bplan-solutions.de>
     */
    public function create(array $attributes): User|DerivedUser
    {
        $Action = new Create();

        return $Action->execute($attributes);

    } // create()


    /**
     *
     * @param       int|string|User|DerivedUser $user
     *
     * @return      User|DerivedUser
     *
     * @version     2.0.0 / 2025-05-03
     * @author      Emilio Cannarozzo <emilio.cannarozzo@bplan-solutions.de>
     * @author      Wassilios Meletiadis <wassilios.meletiadis@bplan-solutions.de>
     */
    public function delete(int|string|User|DerivedUser $user): User|DerivedUser
    {
        $Action = new Delete();

        return $Action->execute($user);

    } // delete()


    /**
     *
     * @param       int|string|User|DerivedUser $user
     *
     * @return      User
     *
     * @version     1.0.0 / 2025-05-03
     * @author      Emilio Cannarozzo <emilio.cannarozzo@bplan-solutions.de>
     * @author      Wassilios Meletiadis <wassilios.meletiadis@bplan-solutions.de>
     */
    public function resetPassword(int|string|User|DerivedUser $user): User|DerivedUser
    {
        $Action = new ResetPassword();

        return $Action->execute($user);

    } // resetPassword()


    /**
     *
     * @param       int|string|User $user
     *
     * @param       array $attributes
     *
     * @return      User|DerivedUser
     *
     * @version     2.0.0 / 2025-05-03
     * @author      Emilio Cannarozzo <emilio.cannarozzo@bplan-solutions.de>
     * @author      Wassilios Meletiadis <wassilios.meletiadis@bplan-solutions.de>
     */
    public function update(int|string|User|DerivedUser $user, array $attributes): User|DerivedUser
    {
        $Action = new Update();

        return $Action->execute($user, $attributes);

    } // update()


/* +++ CLASS METHODS +++ ++++++++++++++++++++++++++++++++++++++++++++++++++++ */


} // class UserService {}
