<?php
/**
 * Service Class
 *
 * @version     1.0.$Revision:$
 * @version     SVN: $Id:$
 * @generated   2025-05-14 15:04:44
 * @package     bplan-base/globals
 * @subpackage  Services
 * @author      Emilio Cannarozzo <emilio.cannarozzo@bplan-solutions.de>
 * @author      Wassilios Meletiadis <wassilios.meletiadis@bplan-solutions.de>
 * @copyright   Copyright (C) 2025 bplan-solutions GmbH & Co. KG <https://www.bplan-solutions.de/>
 * /Δ\
 */

namespace BplanBase\Globals\Services;


use App\Models\Tenant as DerivedTenant;
use App\Models\TenantRecord as DerivedTenantRecord;
use BplanBase\Globals\Actions\TenantRecord\Create;
use BplanBase\Globals\Actions\TenantRecord\Delete;
use BplanBase\Globals\Actions\TenantRecord\Update;
use BplanBase\Globals\Actions\TenantRecord\UpdateActiveStatus;
use BplanBase\Globals\Models\Tenant;
use BplanBase\Globals\Models\TenantRecord;


/**
 * Service Class
 *
 * @version     2.0.0 / 2025-05-27
 * @author      Emilio Cannarozzo <emilio.cannarozzo@bplan-solutions.de>
 * @author      Wassilios Meletiadis <wassilios.meletiadis@bplan-solutions.de>
 */
class TenantRecordService
{

/* +++ TRAITS +++ +++++++++++++++++++++++++++++++++++++++++++++++++++++++++++ */


/* +++ CLASS CONSTANTS +++ ++++++++++++++++++++++++++++++++++++++++++++++++++ */


/* +++ OBJECT MEMBERS +++ +++++++++++++++++++++++++++++++++++++++++++++++++++ */


/* +++ CLASS MEMBERS +++ ++++++++++++++++++++++++++++++++++++++++++++++++++++ */


/* +++ OBJECT METHODS +++ +++++++++++++++++++++++++++++++++++++++++++++++++++ */


    /**
     *
     * @param       Tenant|DerivedTenant $Tenant
     *
     * @return      TenantRecord|DerivedTenantRecord
     *
     * @version     2.0.0 / 2025-05-27
     * @author      Emilio Cannarozzo <emilio.cannarozzo@bplan-solutions.de>
     * @author      Wassilios Meletiadis <wassilios.meletiadis@bplan-solutions.de>
     */
    public function create(Tenant|DerivedTenant $Tenant): TenantRecord|DerivedTenantRecord
    {
        $Action = new Create();

        return $Action->execute($Tenant);

    } // create()


    /**
     *
     * @param       int|string|TenantRecord|DerivedTenantRecord $tenantRecord
     *
     * @return      TenantRecord|DerivedTenantRecord
     *
     * @version     2.0.0 / 2025-05-14
     * @author      Emilio Cannarozzo <emilio.cannarozzo@bplan-solutions.de>
     * @author      Wassilios Meletiadis <wassilios.meletiadis@bplan-solutions.de>
     */
    public function delete(int|string|TenantRecord|DerivedTenantRecord $tenantRecord): TenantRecord|DerivedTenantRecord
    {
        $Action = new Delete();

        return $Action->execute($tenantRecord);

    } // delete()


    /**
     *
     * @param       int|string|TenantRecord|DerivedTenantRecord $tenantRecord
     *
     * @param       array|Tenant|DerivedTenant $tenant
     *
     * @return      TenantRecord|DerivedTenantRecord
     *
     * @version     3.0.0 / 2025-05-27
     * @author      Emilio Cannarozzo <emilio.cannarozzo@bplan-solutions.de>
     * @author      Wassilios Meletiadis <wassilios.meletiadis@bplan-solutions.de>
     */
    public function update(int|string|TenantRecord|DerivedTenantRecord $tenantRecord, array|Tenant|DerivedTenant $tenant): TenantRecord|DerivedTenantRecord
    {
        $Action = new Update();

        return $Action->execute($tenantRecord, $tenant);

    } // update()


    /**
     *
     * @param       int|string|TenantRecord|DerivedTenantRecord $tenantRecord
     *
     * @param       bool $status
     *
     * @return      TenantRecord|DerivedTenantRecord
     *
     * @version     1.0.0 / 2025-05-27
     * @author      Emilio Cannarozzo <emilio.cannarozzo@bplan-solutions.de>
     * @author      Wassilios Meletiadis <wassilios.meletiadis@bplan-solutions.de>
     */
    public function updateActiveStatus(int|string|TenantRecord|DerivedTenantRecord $tenantRecord, bool $status): TenantRecord|DerivedTenantRecord
    {
        $Action = new UpdateActiveStatus();

        return $Action->execute($tenantRecord, $status);

    } // update()


/* +++ CLASS METHODS +++ ++++++++++++++++++++++++++++++++++++++++++++++++++++ */


} // class TenantRecordService {}
