<?php
/**
 *
 * @version     1.0.$Revision:$
 * @version     SVN: $Id:$
 * @package     bplan-base/globals
 * @subpackage  ViewComponents
 * @author      Wassilios Meletiadis <wassilios.meletiadis@bplan-solutions.de>
 * @copyright   Copyright (C) 2025 Wassilios Meletiadis <https://www.bplan-solutions.de/>
 * /Δ\
 */

namespace BplanBase\Globals\View\Components\FormElements;


use Closure;


use Illuminate\Support\Collection;
use Illuminate\Contracts\View\View;
use Illuminate\View\Component;


/**
 * HTML-Select
 *
 * Steuert selbstständig die Anzeige der "Bitte auswählen"-Option.
 * Die Option wird bei Pflichfeldern nur dann angezeigt, wenn der Array mit den Auswahlwerten mehr
 * als einen Wert enthält. Dadurch ist die einzige zur Verfügung stehende Option automatisch
 * vorausgewählt.
 * Wenn der Array $values keine Werte enthält, dann wird anstelle des "Bitte auswählen"-Textes nur
 * "--" angezeigt.
 *
 * @version     1.0.0 / 2025-05-25
 * @author      Wassilios Meletiadis <wassilios.meletiadis@bplan-solutions.de>
 */
class Select extends BaseFormElement
{


/* +++ TRAITS +++ +++++++++++++++++++++++++++++++++++++++++++++++++++++++++++ */


/* +++ CLASS CONSTANTS +++ ++++++++++++++++++++++++++++++++++++++++++++++++++ */

const x = 100;

/* +++ OBJECT MEMBERS +++ +++++++++++++++++++++++++++++++++++++++++++++++++++ */


    /**
     * @var     string $selectText
     */
    public $selectText;


    /**
     * @var     array $values
     */
    public $values;


/* +++ CLASS MEMBERS +++ ++++++++++++++++++++++++++++++++++++++++++++++++++++ */


/* +++ OBJECT METHODS +++ +++++++++++++++++++++++++++++++++++++++++++++++++++ */


    /**
     * Create a new component instance.
     *
     * @param       string $name
     *
     * @param       array $values
     *
     * @param       array $attributes
     *
     * @param       bool $hideNullOption
     *
     * @param       bool $disabled
     *
     * @param       bool|null|string $group
     *
     * @param       null|string $label
     *
     * @param       bool $mandatory
     *
     * @param       bool $noWire
     *
     * @param       bool $readOnly
     *
     * @param       mixed $selected
     *
     * @param       int $width
     *
     * @version     1.0.0 / 2025-05-25
     * @author      Wassilios Meletiadis <wassilios.meletiadis@bplan-solutions.de>
     */
    public function __construct(string $name, array|Collection $values, array $attributes = [],
        public bool $hideNullOption = false,
        public null|string $label = '',
        public bool $disabled = false,
        public bool|null|string $group = null,
        public bool $mandatory = false,
        public string $modifier = '',
        public bool $noWire = false,
        public mixed $selected = false,
        public bool $readOnly = false,
        public int $width = 2
    ) {
        $this->values = $values;
// dd(999);
        $this->_init($name);
        $this->_processAttributes($attributes);

        if (empty($this->values)) {
            $this->selectText = '--';
            $this->_attributeStrings['disabled'] = ' disabled="disabled"';

        } else {
            $this->selectText = __('globals::global.select-option.please-select');
        }
        /*
            @todo   Lösung finden.
                    Es funktioniert leider nicht, bei einer einzigen vorhandenen Option, die Null-
                    Option wegzulassen um den Wert direkt vorzuwählen.
                    Die Component erhält keinen Wert, wenn im Select kein aktiver Wechsel der
                    Optionen stattfindet.
        *   /
        if (count($this->values) === 1 && $this->mandatory === true ) {
            $this->hideNullOption = true;
        }
        */
    } // __construct()


    /**
     * Get the view / contents that represent the component.
     *
     * @version     1.0.0 / 2025-05-25
     * @author      Wassilios Meletiadis <wassilios.meletiadis@bplan-solutions.de>
     */
    public function render(): View|Closure|string
    {
        $this->_prepareAttributeString();

        return view('globals::components.form-elements.select');

    } // render()


/* +++ CLASS METHODS +++ ++++++++++++++++++++++++++++++++++++++++++++++++++++ */


} // class Select extends BaseFormElement {}
