<?php
/**
 * Types & Storage
 *
 * @version     1.0.$Revision:$
 * @version     SVN: $Id:$
 * @package     bplan-base/globals
 * @subpackage  Config
 * @author      Wassilios Meletiadis <wassilios.meletiadis@bplan-solutions.de>
 * @copyright   Copyright (C) 2025 bplan-solutions GmbH & Co. KG <https://www.bplan-solutions.de/>
 * /Δ\
 */


use BplanBase\Globals\Enums\DeleteMode;
use BplanBase\Globals\Enums\MetaType;
use BplanBase\Globals\Enums\MetaTypeCharacter;
use BplanBase\Globals\Enums\MetaTypeDatetime;
use BplanBase\Globals\Enums\MetaTypeFile;
use BplanBase\Globals\Enums\MetaTypeJson;
use BplanBase\Globals\Enums\MetaTypeNumeric;
use BplanBase\Globals\Enums\MetaTypeRelation;
use BplanBase\Globals\Enums\MetaTypeUnixtime;
use BplanBase\Globals\Enums\ReverseRelationType;

$maxInt = 2147483647;   //  2(63) - 1
$minInt = $maxInt + 1;  //  -2(63)

//$maxInt = pow(2, 63) - 1;
//$minInt = pow(2, 63);

return [
    /*
    **  Definiert die in allen Datentabellen zur Verfügung stehenden statischen
    **  Felder und den Kontext, in dem sie eingesetzt werden können. */
    'static-fields' => [
        'varVal' => [
            'Information',
            'title',
            //'uuid',       // ???
        ],
        'varDat' => [
            'created',
            'deleted',
            'modified',
        ]
    ],

    // /*
    // **  Definiert die Anzahlen der, in den verschiedenen Datentabellen zur
    // **  Verfügung stehenden Felder, pro Feldtyp. */
    // 'data-storage' => [
    //     'EntityData' => [
    //         'varChr' => 30,
    //         'varDat' => 5,
    //         'varDec' => 5,
    //         'varInt' => 20,
    //         'varKey' => 5,
    //         'varVal' => 20,
    //     ],
    //     'EntitySimpleData' => [
    //         'varChr' => 15,
    //         'varDat' => 3,
    //         'varDec' => 3,
    //         'varInt' => 5,
    //         'varKey' => 2,
    //         'varVal' => 5,
    //     ],
    // ],

    // /*
    // **
    // **  Auswahlwerte für die Eigenschaft "storageType" beim Typ "EntityType". */
    // 'data-storage-types' => [
    //     'Dynamic',
    //     'DynamicRelation',
    //     'Static',
    //     'StaticRelation'
    // ],

    /*
    **  Auswahlwerte für die Eigenschaft "deleteMode" beim Typ "EntityType". */
    'delete-mode-options' => [
        DeleteMode::NoDelete->name,
        DeleteMode::SoftDelete->name,
        DeleteMode::HardDelete->name,
    ],

    /*
    **  Definiert MetaTypes und MetaSubTypes und die zulässigen Feldtypen. */
    'meta-types' => [
        /*
        **  Diverse Textdaten
        **  Die Spezifizierung dient dazu spezielle Typen zu kennzeichnen und eine Validierung der
        **  Daten sowie eine spezialisiertere Speicherung zu ermöglichen. */
        MetaType::Character->name => [
            /*
                @todo   Gedanken machen zu folgenden Punkten:
                        - MultiLine     Könnte als Flag, aber auch als SubType ausgebildet werden.
                                        Als SubType müsste es zwei Typen - in verschiedenen Größen - geben.
            */
            MetaTypeCharacter::Email->name   => 'varChr',            // -
            MetaTypeCharacter::Gtin->name    => 'varChr',            // -
            MetaTypeCharacter::Numeric->name => 'varChr',            // -
            MetaTypeCharacter::Phone->name   => 'varChr',            // -
            MetaTypeCharacter::Plain->name   => 'varVal',            // max & min
            MetaTypeCharacter::Url->name     => 'varChr',            // -
            MetaTypeCharacter::Uuid->name    => 'varChr',            // 36

            //  Eventuell auch eine Möglichkeit diese Felder zu handhaben
            //'Title' => 'title',             // max & min
            //'Information' => 'information', // max & min
        ],
        /*
        **  Datums- und Zeitwerte
        **  Gespeichert wird immer ein vollständiger Timestamp. Die Spezifizierung gibt an welcher
        **  Teil der gespeicherten Daten gelevant ist. */
        MetaType::Datetime->name => [
            MetaTypeDatetime::Date->name     => 'varDat',
            MetaTypeDatetime::Datetime->name => 'varDat',
            MetaTypeDatetime::Period->name   => 'varInt',       // max und/oder min möglich?
            MetaTypeDatetime::Time->name     => 'varDat',
        ],
        MetaType::Json->name => [                               // max und/oder min möglich?
            MetaTypeJson::Character->name => 'varVal',
            MetaTypeJson::Decimal->name   => 'varVal',
            MetaTypeJson::Integer->name   => 'varVal',
            MetaTypeJson::Mixed->name     => 'varVal',          // alternativ zu "Character"
            MetaTypeJson::Numeric->name   => 'varVal',
        ],
        /*
        **  Dateien
        **  Die Dateien werden im Dateisystem abgelegt. In der Datenbank werden lediglich Pfade oder
        **  Dateinamen gespeichert (kann je nach Projekt flexibel gehandhabt werden). */
        MetaType::File->name => [                         // alle max, eventuell auch min
            MetaTypeFile::Audio->name     => 'varChr',
            MetaTypeFile::Binary->name    => 'varChr',
            MetaTypeFile::Document->name  => 'varChr',
            MetaTypeFile::Extension->name => 'varChr',
            MetaTypeFile::Image->name     => 'varChr',
            MetaTypeFile::Media->name     => 'varChr',
            MetaTypeFile::Mime->name      => 'varChr',
            MetaTypeFile::Text->name      => 'varChr',
            MetaTypeFile::Video->name     => 'varChr',
        ],
        MetaType::Numeric->name => [
            /*
            **  Bitmasken werden als Character gespeichert (wegen führender Nullen (0)). */
            MetaTypeNumeric::Bitmask->name  => 'varChr',          // nur exakte Länge
            MetaTypeNumeric::Boolean->name  => 'varInt',          //  -
            MetaTypeNumeric::Currency->name => 'varDec',          // max & min
            MetaTypeNumeric::Decimal->name  => 'varDec',          // max & min
            MetaTypeNumeric::Integer->name  => 'varInt',          // max & min
            MetaTypeNumeric::Mixed->name    => 'varDec',          // max & min
        ],
        MetaType::Relation->name => [
            MetaTypeRelation::BelongsTo->name          => 'varKey',
            MetaTypeRelation::BelongsToMany->name      => 'varKey',
            MetaTypeRelation::BelongsToModel->name     => 'varKey',
            MetaTypeRelation::BelongsToManyModel->name => 'varKey',
        ],
        /*
        **  Datums- und Zeitwerte
        **  Gespeichert wird immer ein vollständiger Unix Timestamp. Die Spezifizierung gibt an
        **  welcher Teil der gespeicherten Daten gelevant ist. */
        MetaType::Unixtime->name => [
            MetaTypeUnixtime::Date->name     => 'varInt',
            MetaTypeUnixtime::Datetime->name => 'varInt',
            MetaTypeUnixtime::Time->name     => 'varInt',
        ],
    ],

    'mime-type-groups' => [
        'application',
        'audio',
        'font',
        'image',
        'text',
        'video',
    ],

    'relation-models' => [
        'Country',
    ],
    /*
            => BelongsTo
            => MorphTo
            => MorphToMany
    */
    'reverse-relation-types' => [
        ReverseRelationType::BelongsTo->name => [
            ReverseRelationType::HasMany->name,
            ReverseRelationType::HasOne->name,
        ],
        ReverseRelationType::BelongsToMany->name => [
            ReverseRelationType::BelongsToMany->name,
        ],
    ],

    'size-limits-maximum' => [
        'varChr' => 255,
        'varDat' => null,
        'varDec' => '(20,10)',
        'varInt' => $maxInt,
        'varKey' => null,
        'varVal' => 65535,  // medium 16,777,215, long 4,294,967,295
        MetaType::Character->name => [
            MetaTypeCharacter::Email->name => 254,
            MetaTypeCharacter::Gtin->name => '8|12|13|14',
            MetaTypeCharacter::Url->name => 2048,
            MetaTypeCharacter::Uuid->name => 36,
        ],
        MetaType::Datetime->name => [
            MetaTypeDatetime::Date->name => '9999-12-31',
            MetaTypeDatetime::Datetime->name => '9999-12-31 23:59:59.499999',
            MetaTypeDatetime::Time->name => '23:59:59',
        ],
        MetaType::File->name => PHP_MAXPATHLEN,
        MetaType::Numeric->name => [
            MetaTypeNumeric::Boolean->name => 1,
        ],
        MetaType::Unixtime->name => [
            MetaTypeUnixtime::Date->name => date('Y-m-d', (int) $maxInt),
            MetaTypeUnixtime::Datetime->name => date('Y-m-d H:i:s', (int) $maxInt),
            MetaTypeUnixtime::Time->name => '23:59:59',
        ],
    ],
    'size-limits-minimum' => [
        'varChr' => null,
        'varDat' => null,
        'varDec' => '-(20,10)',
        'varInt' => $minInt,
        'varKey' => null,
        'varVal' => null,
        MetaType::Datetime->name => [
            MetaTypeDatetime::Date->name => '1000-01-01',
            MetaTypeDatetime::Datetime->name => '1000-01-01 00:00:00.000000',
            MetaTypeDatetime::Time->name => '00:00:00',
        ],
        MetaType::Numeric->name => [
            MetaTypeNumeric::Boolean->name => 0,
        ],
        MetaType::Unixtime->name => [
            MetaTypeUnixtime::Date->name => date('Y-m-d', 0),
            MetaTypeUnixtime::Datetime->name => date('Y-m-d H:i:s', 0),
            MetaTypeUnixtime::Time->name => '00:00:00',
        ],
    ],

    'system-locales' => [
        'de_DE',
        'en_GB',
        'fr_FR',
        'it_IT',
    ],
];