<?php
/**
 * Seeder Class
 *
 * @version     1.0.$Revision:$
 * @version     SVN: $Id:$
 * @package     bplan-base\globals
 * @subpackage  Seeders
 * @author      Wassilios Meletiadis <wassilios.meletiadis@bplan-solutions.de>
 * @copyright   Copyright (C) 2025 bplan-solutions GmbH & Co. KG <https://www.bplan-solutions.de/>
 * /Δ\
 */

namespace BplanBase\Globals\Database\Seeders\Demo;


use App\Models\User;
use BplanBase\Globals\Enums\UserAccessLevel;
use BplanBase\Globals\Models\Tenant;
use Illuminate\Database\Seeder;
use Illuminate\Support\Facades\Hash;
use Illuminate\Support\Str;


/**
 * Seeder Class
 *
 * @author      Wassilios Meletiadis <wassilios.meletiadis@bplan-solutions.de>
 */
class UserSeeder extends Seeder
{

    /**
     * Run the database seeds.
     *
     * @return void
     *
     * @author      Wassilios Meletiadis <wassilios.meletiadis@bplan-solutions.de>
     */
    public function run()
    {
        $date = date('Y-m-d H:i:s');
        $env = strtolower(config('app.env'));

        $Tenant = Tenant::where('identifier', 'System')->first();

        $password = '5qM$K4946P!2he';

        $users = [
            [
                'uuid' => Str::uuid(),
                'active' => 1,
                'created_at' => $date,
                'updated_at' => $date,
                'access_level' => UserAccessLevel::SystemManager->name,
                'email' => 'demo.admin@bplan-solutions.de',
                'internal' => 1,
                'name' => 'Demo Admin',
                'password' => Hash::make($password),
                'tenant_id' => $Tenant->id,
            ],
            [
                'uuid' => Str::uuid(),
                'active' => 1,
                'created_at' => $date,
                'updated_at' => $date,
                'access_level' => UserAccessLevel::Admin->name,
                'email' => 'demo.user@bplan-solutions.de',
                'internal' => 0,
                'name' => 'Demo User',
                'password' => '',
                'tenant_id' => $Tenant->id,
            ],
        ];
        User::insert($users);

    } // run()


} // class UserSeeder extends Seeder {}
