{{--
 *
 * @version     1.0.$Revision:$
 * @version     SVN: $Id:$
 * @package     bplan-base/globals
 * @subpackage  Templates
 * @author      Wassilios Meletiadis <wassilios.meletiadis@bplan-solutions.de>
 * @copyright   Copyright (C) 2025 bplan-solutions GmbH & Co. KG <http://www.bplan-solutions.de/>
 * /Δ\
--}}

                  <div class="px-4 sm:px-6 lg:px-8 min-w-full">
                    <div class="flex flex-col">
                      <div class="-my-2 -mx-4 sm:-mx-6 lg:-mx-8">
                        <div class="inline-block min-w-full py-2 align-middle">
                          <div class="shadow-sm ring-1 ring-black ring-opacity-5">
                            <table class="min-w-full border-separate" style="border-spacing: 0">
                              <thead class="bg-gray-50">
                                <tr>
                                  <th scope="col" class="sticky top-0 z-10 border-b border-gray-300 bg-gray-50 bg-opacity-75 py-3 pl-4 pr-3 text-left text-sm font-semibold backdrop-blur backdrop-filter sm:pl-6 lg:pl-8">{!! __('entitytype-grid.caption.id') !!}</th>
                                  <th scope="col" class="sticky top-0 z-10 border-b border-gray-300 bg-gray-50 bg-opacity-75 py-3 pl-4 pr-3 text-left text-sm font-semibold backdrop-blur backdrop-filter sm:pl-6 lg:pl-8">{!! __('entitytype-grid.caption.identifier') !!}</th>
                                  <th scope="col" class="sticky top-0 z-10 border-b border-gray-300 bg-gray-50 bg-opacity-75 py-3 pl-4 pr-3 text-left text-sm font-semibold backdrop-blur backdrop-filter sm:pl-6 lg:pl-8">{!! __('entitytype-grid.caption.label') !!}</th>
                                  <th scope="col" class="sticky top-0 z-10 border-b border-gray-300 bg-gray-50 bg-opacity-75 py-3 pl-4 pr-3 text-left text-sm font-semibold backdrop-blur backdrop-filter sm:pl-6 lg:pl-8">{!! __('entitytype-grid.caption.resourceContext') !!}</th>
                                  <th scope="col" class="sticky top-0 z-10 border-b border-gray-300 bg-gray-50 bg-opacity-75 py-3 pl-4 pr-3 text-left text-sm font-semibold backdrop-blur backdrop-filter sm:pl-6 lg:pl-8">{!! __('entitytype-grid.caption.resourceName') !!}</th>
                                  <th scope="col" class="sticky top-0 z-10 border-b border-gray-300 bg-gray-50 bg-opacity-75 py-3 pl-4 pr-3 text-left text-sm font-semibold backdrop-blur backdrop-filter sm:pl-6 lg:pl-8">{!! __('entitytype-grid.caption.tenant_id') !!}</th>
                                  <th scope="col" class="sticky top-0 z-10 border-b border-gray-300 bg-gray-50 bg-opacity-75 py-3 pl-4 pr-3 text-left text-sm font-semibold backdrop-blur backdrop-filter sm:pl-6 lg:pl-8">{!! __('entitytype-grid.caption.active') !!}</th>
                                  <th scope="col" class="sticky top-0 z-10 border-b border-gray-300 bg-gray-50 bg-opacity-75 py-3 pl-4 pr-3 text-left text-sm font-semibold backdrop-blur backdrop-filter sm:pl-6 lg:pl-8">{!! __('entitytype-grid.caption.linked') !!}</th>
                                </tr>
                              </thead>
                              <tbody class="bg-white">

@foreach ($AvailableEntityTypes as $resource)
    @php
        $params = [
            'id' => $resource['id'],
            'redirect-to' => [
                'a|c|d|u' => [
                    'params' => [
                        'entity-type-id' => $resource['entity_type_id'],
                        'entity-type-field-id' => $resource['id'],
                        'tab' => 'foreign',
                    ],
                ],
            ],
        ];
        $linked = isset($linkedEntityTypeIDs[$resource['id']])
            ? $activeStatus[1] : $activeStatus[0];

    @endphp

                                <tr class="{!! ($resource['id'] == $highlightID ? 'bg-green-50' : '')  !!}" onclick="window.location.href='{!! route('entity-type', $params) !!}';">
                                  <td class="whitespace-nowrap border-b border-gray-200 py-4 pl-4 pr-3 text-left text-sm font-medium text-gray-900 sm:pl-6 lg:pl-8">{!! $resource['id'] !!}</td>
                                  <td class="whitespace-nowrap border-b border-gray-200 py-4 pl-4 pr-3 text-left text-sm font-medium text-gray-900 sm:pl-6 lg:pl-8">{!! $resource['identifier'] !!}</td>
                                  <td class="whitespace-nowrap border-b border-gray-200 py-4 pl-4 pr-3 text-left text-sm font-medium text-gray-900 sm:pl-6 lg:pl-8">{!! $resource['label'] !!}</td>
                                  <td class="whitespace-nowrap border-b border-gray-200 py-4 pl-4 pr-3 text-left text-sm font-medium text-gray-900 sm:pl-6 lg:pl-8">{!! $resource['resourceContext'] !!}</td>
                                  <td class="whitespace-nowrap border-b border-gray-200 py-4 pl-4 pr-3 text-left text-sm font-medium text-gray-900 sm:pl-6 lg:pl-8">{!! $resource['resourceName'] !!}</td>
                                  <td class="whitespace-nowrap border-b border-gray-200 py-4 pl-4 pr-3 text-left text-sm font-medium text-gray-900 sm:pl-6 lg:pl-8">{!! $tenants[$resource['tenant_id']] !!}</td>
                                  <td class="whitespace-nowrap border-b border-gray-200 py-4 pl-4 pr-3 text-left text-sm font-medium text-gray-900 sm:pl-6 lg:pl-8">{!! $activeStatus[$resource['active']] !!}</td>
                                  <td class="whitespace-nowrap border-b border-gray-200 py-4 pl-4 pr-3 text-left text-sm font-medium text-gray-900 sm:pl-6 lg:pl-8">{!! $linked !!}</td>
                                </tr>

@endforeach

                              </tbody>
                            </table>
                          </div>
                        </div>

                      </div>
                    </div>
                  </div>
