<?php
/**
 * Copy Action Class
 *
 * @version     1.0.$Revision:$
 * @version     SVN: $Id:$
 * @package     bplan-base/globals
 * @subpackage  Actions
 * @author      Emilio Cannarozzo <emilio.cannarozzo@bplan-solutions.de>
 * @author      Wassilios Meletiadis <wassilios.meletiadis@bplan-solutions.de>
 * @copyright   Copyright (C) 2025 bplan-solutions GmbH & Co. KG <https://www.bplan-solutions.de/>
 * /Δ\
 */

namespace BplanBase\Globals\Actions\EntityTypeField;


use App\Models\EntityType as DerivedEntityType;
use App\Models\EntityTypeField as DerivedEntityTypeField;
use BplanBase\Globals\Models\EntityType;
use BplanBase\Globals\Models\EntityTypeField;
use Illuminate\Support\Str;


/**
 * Copy Action Class
 *
 * @version     1.0.0 / 2025-05-29
 * @author      Wassilios Meletiadis <wassilios.meletiadis@bplan-solutions.de>
 */
class Copy
{

/* +++ TRAITS +++ +++++++++++++++++++++++++++++++++++++++++++++++++++++++++++ */


/* +++ CLASS CONSTANTS +++ ++++++++++++++++++++++++++++++++++++++++++++++++++ */


/* +++ OBJECT MEMBERS +++ +++++++++++++++++++++++++++++++++++++++++++++++++++ */


/* +++ CLASS MEMBERS +++ ++++++++++++++++++++++++++++++++++++++++++++++++++++ */


/* +++ OBJECT METHODS +++ +++++++++++++++++++++++++++++++++++++++++++++++++++ */


    /**
     *
     * @param       int|string|EntityTypeField|DerivedEntityTypeField $field
     *
     * @param       int|string|EntityType|DerivedEntityType $entityType
     *
     * @return      EntityTypeField|DerivedEntityTypeField
     *
     * @version     1.0.0 / 2025-05-29
     * @author      Wassilios Meletiadis <wassilios.meletiadis@bplan-solutions.de>
     */
    public function execute(int|string|EntityTypeField|DerivedEntityTypeField $field, int|string|EntityType|DerivedEntityType $entityType): EntityTypeField|DerivedEntityTypeField
    {
        if ($field instanceof EntityTypeField) {
            $Source = $field;
        } else {
            $Source = EntityTypeField::findOrFail($field);
        }
        if ($entityType instanceof EntityType) {
            $entityTypeId = $entityType->id;
        } else {
            $entityTypeId = $entityType;
        }
        $Model = $Source->replicate(['deleted', 'entity_type_id']);

        $Model->active = true;
        $Model->entity_type_id = $entityTypeId;

        $Model->save();

        return $Model;

    } // execute()


} // Copy {}
