<?php #CodeGenerator Δ 880d667b17a89dc58a262d386c0da0ef Δ DYNAMICALLY GENERATED FILE - Do not modify this line! Remove it completely to protect the file from changes.
/**
 * JSON:API Schema Class
 *
 * @version     1.0.$Revision:$
 * @version     SVN: $Id:$
 * @generated   2025-05-18 20:28:29
 * @package     bplan-base/globals
 * @subpackage  Schemas
 * @author      Emilio Cannarozzo <emilio.cannarozzo@bplan-solutions.de>
 * @author      Wassilios Meletiadis <wassilios.meletiadis@bplan-solutions.de>
 * @copyright   Copyright (C) 2025 bplan-solutions GmbH & Co. KG <https://www.bplan-solutions.de/>
 * /Δ\
 */

namespace BplanBase\Globals\JsonApi\Terminal\Countries;


use BplanBase\Globals\Models\Country;
use Illuminate\Database\Eloquent\Builder;
use Illuminate\Http\Request;
use LaravelJsonApi\Eloquent\Contracts\Paginator;
use LaravelJsonApi\Eloquent\Fields\ArrayHash;
use LaravelJsonApi\Eloquent\Fields\ArrayList;
use LaravelJsonApi\Eloquent\Fields\Boolean;
use LaravelJsonApi\Eloquent\Fields\ID;
use LaravelJsonApi\Eloquent\Fields\Relations\HasMany;
use LaravelJsonApi\Eloquent\Fields\Str;
use LaravelJsonApi\Eloquent\Filters\WhereIdIn;
use LaravelJsonApi\Eloquent\Pagination\PagePagination;
use LaravelJsonApi\Eloquent\Schema;


/**
 * JSON:API Schema Class
 *
 * @version     2.2.0 / 2025-05-18
 * @author      Emilio Cannarozzo <emilio.cannarozzo@bplan-solutions.de>
 * @author      Wassilios Meletiadis <wassilios.meletiadis@bplan-solutions.de>
 */
class CountrySchema extends Schema
{


/* +++ TRAITS +++ +++++++++++++++++++++++++++++++++++++++++++++++++++++++++++ */


/* +++ CLASS CONSTANTS +++ ++++++++++++++++++++++++++++++++++++++++++++++++++ */


/* +++ OBJECT MEMBERS +++ +++++++++++++++++++++++++++++++++++++++++++++++++++ */


    /**
     * The maximum include path depth.
     *
     * @var int
     */
    protected int $maxDepth = 2;


/* +++ CLASS MEMBERS +++ ++++++++++++++++++++++++++++++++++++++++++++++++++++ */


    /**
     * The model the schema corresponds to.
     *
     * @var         string
     */
    public static string $model = Country::class;


/* +++ OBJECT METHODS +++ +++++++++++++++++++++++++++++++++++++++++++++++++++ */


    /**
     * Get the resource fields.
     *
     * @return      array
     *
     * @version     1.3.0 / 2025-05-18
     * @author      Emilio Cannarozzo <emilio.cannarozzo@bplan-solutions.de>
     * @author      Wassilios Meletiadis <wassilios.meletiadis@bplan-solutions.de>
     */
    public function fields(): array
    {
        return [
            ID::make(),

            Boolean::make('active')->sortable(),

            Str::make('area'),
            ArrayHash::make('capitalNames')->sortable(),
            Str::make('comments'),
            Str::make('fips10'),
            Str::make('ioc'),
            Str::make('iso3166Alpha2')->sortable(),
            Str::make('iso3166Alpha3')->sortable(),
            Str::make('iso3166Numeric')->sortable(),
            ArrayList::make('locales')->sortable(),
            Str::make('localName'),
            ArrayHash::make('longNames')->sortable(),
            ArrayHash::make('nationalityNames')->sortable(),
            Str::make('natoCountryCode2'),
            Str::make('natoCountryCode3'),
            ArrayHash::make('shortNames')->sortable(),
            Str::make('telephoneCountryCode')->sortable(),
            Str::make('telephoneCountryCodeExtended')->sortable(),
            Str::make('tld'),
            Str::make('vehicleRegistrationCode'),
            /*
            **  Relations */
            HasMany::make('tenant-records')->type('tenant-records')->serializeUsing(
                static fn($Relation) => $Relation->alwaysShowData()
            ),

        ];
    } // fields()


    /**
     * Get the resource filters.
     *
     * @return      array
     *
     * @version     1.0.0 / 2025-05-18
     * @author      Emilio Cannarozzo <emilio.cannarozzo@bplan-solutions.de>
     * @author      Wassilios Meletiadis <wassilios.meletiadis@bplan-solutions.de>
     */
    public function filters(): array
    {
        return [
            WhereIdIn::make($this),
        ];
    } // filters()


    /**
     * Build an index query for this resource.
     *
     * @param       Request|null $Request
     *
     * @param       Builder $Query
     *
     * @return      Builder

     * @version     1.0.0 / 2025-05-18
     * @author      Emilio Cannarozzo <emilio.cannarozzo@bplan-solutions.de>
     * @author      Wassilios Meletiadis <wassilios.meletiadis@bplan-solutions.de>
     */
    public function indexQuery(?Request $Request, Builder $Query): Builder
    {
        return $Query->where(function (Builder $Query) {
            return $Query->where('active', '=', 1);
        });
    } // indexQuery()


    /**
     * Get the resource paginator.
     *
     * @return      null|Paginator
     *
     * @version     1.0.0 / 2025-05-18
     * @author      Emilio Cannarozzo <emilio.cannarozzo@bplan-solutions.de>
     * @author      Wassilios Meletiadis <wassilios.meletiadis@bplan-solutions.de>
     */
    public function pagination(): ?Paginator
    {
        return PagePagination::make();

    } // pagination()


/* +++ CLASS METHODS +++ ++++++++++++++++++++++++++++++++++++++++++++++++++++ */


} // class CountrySchema extends Schema {}
