<?php
/**
 * Model Class
 *
 * @version     1.0.$Revision:$
 * @version     SVN: $Id:$
 * @generated   2025-05-24 23:01:45
 * @package     bplan-base/globals
 * @subpackage  Models
 * @author      Emilio Cannarozzo <emilio.cannarozzo@bplan-solutions.de>
 * @author      Wassilios Meletiadis <wassilios.meletiadis@bplan-solutions.de>
 * @copyright   Copyright (C) 2025 bplan-solutions GmbH & Co. KG <https://www.bplan-solutions.de/>
 * /Δ\
 */

namespace BplanBase\Globals\Models;


use BplanBase\Globals\Observers\EntityTypeObserver;
use BplanBase\Globals\Scopes\TenantScope;
use BplanBase\Globals\Traits\HasActiveScope;
use BplanBase\Globals\Traits\HasNoInternalScope;
use BplanBase\Globals\Traits\HasOrderedScope;
use Illuminate\Database\Eloquent\Attributes\ObservedBy;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Relations\BelongsTo;
use Illuminate\Database\Eloquent\Relations\BelongsToMany;
use Illuminate\Database\Eloquent\Relations\HasMany;
use Illuminate\Database\Eloquent\SoftDeletes;


/**
 * Model Class
 *
 * @version     1.4.0 / 2025-05-24
 * @author      Emilio Cannarozzo <emilio.cannarozzo@bplan-solutions.de>
 * @author      Wassilios Meletiadis <wassilios.meletiadis@bplan-solutions.de>
 */
#[ObservedBy([EntityTypeObserver::class])]
class EntityType extends Model
{


/* +++ TRAITS +++ +++++++++++++++++++++++++++++++++++++++++++++++++++++++++++ */


    use HasActiveScope;
    use HasNoInternalScope;
    use HasOrderedScope;
    use SoftDeletes;


/* +++ CLASS CONSTANTS +++ ++++++++++++++++++++++++++++++++++++++++++++++++++ */


/* +++ OBJECT MEMBERS +++ +++++++++++++++++++++++++++++++++++++++++++++++++++ */


    /**
     * The accessors to append to the model's array form.
     *
     * @var         array<int, string> $appends
     *
     * @version     1.0.0 / 2025-05-24
     */
    protected $appends = [];


    /**
     * @var         array<string, string> $casts
     *
     * @version     1.0.0 / 2025-05-24
     */
    protected $casts = [
        'abstract'        => 'boolean',
        'active'          => 'boolean',
        'creatable'       => 'boolean',
        'created_at'      => 'datetime',
        'deleted_at'      => 'datetime',
        'editable'        => 'boolean',
        'historize'       => 'boolean',
        'internal'        => 'boolean',
        'journalize'      => 'boolean',
        'labels'          => 'object',
        'require_release' => 'boolean',
        'updated_at'      => 'datetime',
        'visible'         => 'boolean',
    ];


    /**
     * The attributes that are mass assignable.
     *
     * @var         array<int, string> $fillable
     *
     * @version     1.0.0 / 2025-05-24
     */
    protected $fillable = [
        'abstract',
        'active',
        'creatable',
        'delete_mode',
        'edit_type',
        'editable',
        'historize',
        // 'identifier',
        'internal',
        'journalize',
        'labels',
        'main_type',
        'master_id',
        'model_id',
        'require_release',
        'resource_name',
        'source_id',
        'sub_type',
        'visible',
    ];


    /**
     * The attributes that aren't mass assignable.
     *
     * @var         array<int, string> $guarded
     *
     * @version     1.0.0 / 2025-05-24
     */
    protected $guarded = [
        'created_at',
        'deleted_at',
        'tenant_id',
        'updated_at',
        'uuid',
    ];


    /**
     * The attributes that should be hidden for serialization.
     *
     * @var         array<int, string> $hidden
     *
     * @version     1.0.0 / 2025-05-24
     */
    protected $hidden = [];


    /**
     * The table associated with the model.
     *
     * @var         string $table
     */
    protected $table = 'entity_types';


    /**
     * Indicates if the model should be timestamped.
     *
     * @var         bool $timestamps
     */
    public $timestamps = true;


/* +++ CLASS MEMBERS +++ ++++++++++++++++++++++++++++++++++++++++++++++++++++ */


/* +++ OBJECT METHODS +++ +++++++++++++++++++++++++++++++++++++++++++++++++++ */


    /**
     *
     * @return      void
     *
     * @version     1.0.0 / 2025-05-20
     * @author      Wassilios Meletiadis <wassilios.meletiadis@bplan-solutions.de>
     */
    protected static function booted(): void
    {
        static::addGlobalScope(new TenantScope());

    } // booted()


    /**
     *
     * @return      HasMany
     *
     * @version     1.0.0 / 2025-05-24
     * @author      Emilio Cannarozzo <emilio.cannarozzo@bplan-solutions.de>
     * @author      Wassilios Meletiadis <wassilios.meletiadis@bplan-solutions.de>
     */
    public function derivedEntityTypes(): HasMany
    {
        return $this->hasMany(EntityType::class, 'source_id');

    } // derivedEntityTypes()


    /**
     *
     * @return      BelongsTo
     *
     * @version     1.0.0 / 2025-05-24
     * @author      Emilio Cannarozzo <emilio.cannarozzo@bplan-solutions.de>
     * @author      Wassilios Meletiadis <wassilios.meletiadis@bplan-solutions.de>
     */
    public function masterEntityType(): BelongsTo
    {
        return $this->belongsTo(EntityType::class, 'master_id');

    } // masterEntityType()


    /**
     *
     * @return      BelongsTo
     *
     * @version     1.0.0 / 2025-05-24
     * @author      Emilio Cannarozzo <emilio.cannarozzo@bplan-solutions.de>
     * @author      Wassilios Meletiadis <wassilios.meletiadis@bplan-solutions.de>
     */
    public function model(): BelongsTo
    {
        return $this->belongsTo(EntityTypeModel::class, 'model_id');

    } // model()


    /**
     *
     * @return      BelongsTo
     *
     * @version     1.0.0 / 2025-05-24
     * @author      Emilio Cannarozzo <emilio.cannarozzo@bplan-solutions.de>
     * @author      Wassilios Meletiadis <wassilios.meletiadis@bplan-solutions.de>
     */
    public function sourceEntityType(): BelongsTo
    {
        return $this->belongsTo(EntityType::class, 'source_id');

    } // sourceEntityType()


    /**
     *
     * @return      HasMany
     *
     * @version     1.0.0 / 2025-05-24
     * @author      Emilio Cannarozzo <emilio.cannarozzo@bplan-solutions.de>
     * @author      Wassilios Meletiadis <wassilios.meletiadis@bplan-solutions.de>
     */
    public function subEntityTypes(): HasMany
    {
        return $this->hasMany(EntityType::class, 'master_id');

    } // subEntityTypes()


    /**
     *
     * @return      BelongsTo
     *
     * @version     1.0.0 / 2025-05-24
     * @author      Emilio Cannarozzo <emilio.cannarozzo@bplan-solutions.de>
     * @author      Wassilios Meletiadis <wassilios.meletiadis@bplan-solutions.de>
     */
    public function tenant(): BelongsTo
    {
        return $this->belongsTo(Tenant::class, 'tenant_id');

    } // tenant()


    /**
     *
     * @return      BelongsToMany
     *
     * @version     1.0.1 / 2025-05-24
     * @author      Emilio Cannarozzo <emilio.cannarozzo@bplan-solutions.de>
     * @author      Wassilios Meletiadis <wassilios.meletiadis@bplan-solutions.de>
     */
    public function tenants(): BelongsToMany
    {
        return $this->belongsToMany(Tenant::class, 'entity_type_tenant', 'entity_type_id', 'tenant_id')->withPivot('active', 'created_at', 'uuid');

    } // tenants()


/* +++ CLASS METHODS +++ ++++++++++++++++++++++++++++++++++++++++++++++++++++ */


} // class EntityType extends Model {}
