<?php
/**
 * Service Class
 *
 * @version     1.0.$Revision:$
 * @version     SVN: $Id:$
 * @generated   2025-05-23 17:04:36
 * @package     bplan-base/globals
 * @subpackage  Services
 * @author      Emilio Cannarozzo <emilio.cannarozzo@bplan-solutions.de>
 * @author      Wassilios Meletiadis <wassilios.meletiadis@bplan-solutions.de>
 * @copyright   Copyright (C) 2025 bplan-solutions GmbH & Co. KG <https://www.bplan-solutions.de/>
 * /Δ\
 */

namespace BplanBase\Globals\Services;


use App\Models\ExternalSystem as DerivedExternalSystem;
use App\Models\TenantExternalSystem as DerivedTenantExternalSystem;
use BplanBase\Globals\Actions\TenantExternalSystem\Create;
use BplanBase\Globals\Actions\TenantExternalSystem\Delete;
use BplanBase\Globals\Actions\TenantExternalSystem\Instantiate;
use BplanBase\Globals\Actions\TenantExternalSystem\Update;
use BplanBase\Globals\Models\ExternalSystem;
use BplanBase\Globals\Models\TenantExternalSystem;


/**
 * Service Class
 *
 * @version     2.0.0 / 2025-05-29
 * @author      Emilio Cannarozzo <emilio.cannarozzo@bplan-solutions.de>
 * @author      Wassilios Meletiadis <wassilios.meletiadis@bplan-solutions.de>
 */
class TenantExternalSystemService
{

/* +++ TRAITS +++ +++++++++++++++++++++++++++++++++++++++++++++++++++++++++++ */


/* +++ CLASS CONSTANTS +++ ++++++++++++++++++++++++++++++++++++++++++++++++++ */


/* +++ OBJECT MEMBERS +++ +++++++++++++++++++++++++++++++++++++++++++++++++++ */


/* +++ CLASS MEMBERS +++ ++++++++++++++++++++++++++++++++++++++++++++++++++++ */


/* +++ OBJECT METHODS +++ +++++++++++++++++++++++++++++++++++++++++++++++++++ */


    /**
     *
     * @param       array $attributes
     *
     * @return      TenantExternalSystem|DerivedTenantExternalSystem
     *
     * @version     1.0.0 / 2025-05-23
     * @author      Emilio Cannarozzo <emilio.cannarozzo@bplan-solutions.de>
     * @author      Wassilios Meletiadis <wassilios.meletiadis@bplan-solutions.de>
     */
    public function create(array $attributes): TenantExternalSystem|DerivedTenantExternalSystem
    {
        $Action = new Create();

        return $Action->execute($attributes);

    } // create()


    /**
     *
     * @param       int|string|TenantExternalSystem|DerivedTenantExternalSystem $tenantExternalSystem
     *
     * @return      TenantExternalSystem|DerivedTenantExternalSystem
     *
     * @version     2.0.0 / 2025-05-23
     * @author      Emilio Cannarozzo <emilio.cannarozzo@bplan-solutions.de>
     * @author      Wassilios Meletiadis <wassilios.meletiadis@bplan-solutions.de>
     */
    public function delete(int|string|TenantExternalSystem|DerivedTenantExternalSystem $tenantExternalSystem): TenantExternalSystem|DerivedTenantExternalSystem
    {
        $Action = new Delete();

        return $Action->execute($tenantExternalSystem);

    } // delete()


    /**
     *
     * @param       int|string|ExternalSystem|DerivedExternalSystem $externalSystem
     *
     * @return      TenantExternalSystem|DerivedTenantExternalSystem
     *
     * @version     1.0.0 / 2025-05-29
     * @author      Emilio Cannarozzo <emilio.cannarozzo@bplan-solutions.de>
     * @author      Wassilios Meletiadis <wassilios.meletiadis@bplan-solutions.de>
     */
    public function instantiate(int|string|ExternalSystem|DerivedExternalSystem $externalSystem): TenantExternalSystem|DerivedTenantExternalSystem
    {
        $Action = new Instantiate();

        return $Action->execute($externalSystem);

    } // instantiate()


    /**
     *
     * @param       int|string|TenantExternalSystem|DerivedTenantExternalSystem $tenantExternalSystem
     *
     * @param       array $attributes
     *
     * @return      TenantExternalSystem|DerivedTenantExternalSystem
     *
     * @version     2.0.0 / 2025-05-23
     * @author      Emilio Cannarozzo <emilio.cannarozzo@bplan-solutions.de>
     * @author      Wassilios Meletiadis <wassilios.meletiadis@bplan-solutions.de>
     */
    public function update(int|string|TenantExternalSystem|DerivedTenantExternalSystem $tenantExternalSystem, array $attributes): TenantExternalSystem|DerivedTenantExternalSystem
    {
        $Action = new Update();

        return $Action->execute($tenantExternalSystem, $attributes);

    } // update()


/* +++ CLASS METHODS +++ ++++++++++++++++++++++++++++++++++++++++++++++++++++ */


} // class TenantExternalSystemService {}
