<?php
/**
 * Migration Class
 *
 * @version     1.0.$Revision:$
 * @version     SVN: $Id:$
 * @package     bplan-base/globals
 * @subpackage  Migrations
 * @author      Emilio Cannarozzo <emilio.cannarozzo@bplan-solutions.de>
 * @author      Wassilios Meletiadis <wassilios.meletiadis@bplan-solutions.de>
 * @copyright   Copyright (C) 2025 bplan-solutions GmbH & Co. KG <https://www.bplan-solutions.de/>
 * /Δ\
 */


use BplanBase\CodeGenerator\Loaders\CodeGenerator;
use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;


/**
 * Migration Class
 *
 * @author      Emilio Cannarozzo <emilio.cannarozzo@bplan-solutions.de>
 * @author      Wassilios Meletiadis <wassilios.meletiadis@bplan-solutions.de>
 */
return new class extends Migration
{

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('system_components');

    } // down()


    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('system_components', function (Blueprint $Table) {
            $Table->id();
            $Table->uuid('uuid');

            $Table->timestamp('created_at');
            $Table->timestamp('updated_at');

            $Table->timestamp('date')->nullable();
            $Table->string('identifier', 100);
            $Table->text('info');
            $Table->string('path', 255)->nullable();
            $Table->unsignedInteger('size')->nullable();
            $Table->string('version', 50);

            $Table->unique('identifier', 'system_components_UKI_identifier');

        });
    } // up()

};
