<?php
/**
 * Migration Class
 *
 * @version     1.0.$Revision:$
 * @version     SVN: $Id:$
 * @package     bplan-base/globals
 * @subpackage  Migrations
 * @author      Emilio Cannarozzo <emilio.cannarozzo@bplan-solutions.de>
 * @author      Wassilios Meletiadis <wassilios.meletiadis@bplan-solutions.de>
 * @copyright   Copyright (C) 2025 bplan-solutions GmbH & Co. KG <https://www.bplan-solutions.de/>
 * /Δ\
 */


use BplanBase\CodeGenerator\Loaders\CodeGenerator;
use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;


/**
 * Migration Class
 *
 * @author      Wassilios Meletiadis <wassilios.meletiadis@bplan-solutions.de>
 */
return new class extends Migration
{


    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('entity_type_field_definitions');

    } // down()


    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('entity_type_field_definitions', function (Blueprint $Table) {
            $Table->id();
            $Table->uuid('uuid');
            $Table->boolean('active')->default(1);

            $Table->timestamp('created_at');
            $Table->softDeletes('deleted_at');
            $Table->timestamp('updated_at');

            $Table->boolean('editable')->default(0);
            $Table->foreignId('entity_type_id')->constrained(table: 'entity_types', indexName: 'entity_type_field_definitions_FK_entity_type_id');
            $Table->foreignId('field_id')->constrained(table: 'entity_type_fields', indexName: 'entity_type_field_definitions_FK_field_id');
            $Table->boolean('mandatory')->default(0);
            $Table->boolean('sortable')->default(0);

            $Table->index('entity_type_id', 'entity_type_field_definitions_FK_entity_type_id');
            $Table->index('field_id',       'entity_type_field_definitions_FK_field_id');

            new CodeGenerator($Table, [
                'columns' => [
                    'active' => [
                        'sortable' => true,
                    ],
                    'entity_type_id' => [
                        'reverseRelationName' => 'field-definitions',
                    ],
                    'field_id' => [
                        'reverseRelationName' => 'field-definitions',
                    ],
                    'identifier' => [
                        'sortable' => true,
                    ],
                    'sortable' => [
                        'guarded' => true,
                    ]
                ],
                'indexQueries' => [
                    'terminal' => '$Query->where(\'active\', \'=\', 1)',
                ],
                'routing' => [
                    'terminal' => 'readOnly',
                ],
                'traits' => [
                    'laravel.model' => [
                        'BplanBase\\Globals\Traits\\HasActiveScope',
                        'BplanBase\\Globals\Traits\\HasOrderedScope',
                    ],
                ],

            ]);

        });
    } // up()


};
