<?php
/**
 * Seeder Class
 *
 * @version     1.0.$Revision:$
 * @version     SVN: $Id:$
 * @package     bplan-base/globals
 * @subpackage  Seeders
 * @author      Wassilios Meletiadis <wassilios.meletiadis@bplan-solutions.de>
 * @copyright   Copyright (C) 2025 bplan-solutions GmbH & Co. KG <https://www.bplan-solutions.de/>
 * /Δ\
 */

namespace BplanBase\Globals\Database\Seeders;


use Illuminate\Database\Seeder;


/**
 * Seeder Class
 *
 * @author      Wassilios Meletiadis <wassilios.meletiadis@bplan-solutions.de>
 */
class DatabaseSeeder extends Seeder
{


    /**
     * Seed the application's database.
     */
    public function run(): void
    {
        $env = strtolower(config('app.env'));

        $seeds = [
            RegisterModuleSeeder::class,
            CountrySeeder::class,
            ExternalSystemSeeder::class,
            TenantSeeder::class,
            TenantRecordSeeder::class,
            TenantLocaleSeeder::class,
            RoleSeeder::class,
            UserSeeder::class,
            UserRecordSeeder::class,
            RoleUserSeeder::class,
        ];
        if ($env === 'production') {
            //

        } elseif (str_starts_with($env, 'demo') === true) {
            $seeds[] = Dev\TenantExternalSystemSeeder::class;
            $seeds[] = Dev\UserSeeder::class;
            $seeds[] = Demo\UserSeeder::class;
            $seeds[] = Dev\UserRecordSeeder::class;
            $seeds[] = Demo\UserRecordSeeder::class;

        } else {
            $seeds[] = Dev\TenantExternalSystemSeeder::class;
            $seeds[] = Dev\UserSeeder::class;
            $seeds[] = Dev\UserRecordSeeder::class;

        }
        $this->call($seeds);

    } // run()


} // class DatabaseSeeder extends Seeder
