<?php
/**
 * Update Action Class
 *
 * @version     1.0.$Revision:$
 * @version     SVN: $Id:$
 * @package     bplan-base/globals
 * @subpackage  Actions
 * @author      Emilio Cannarozzo <emilio.cannarozzo@bplan-solutions.de>
 * @author      Wassilios Meletiadis <wassilios.meletiadis@bplan-solutions.de>
 * @copyright   Copyright (C) 2025 bplan-solutions GmbH & Co. KG <https://www.bplan-solutions.de/>
 * /Δ\
 */

namespace BplanBase\Globals\Actions\TenantRecord;


use App\Models\TenantRecord as DerivedTenantRecord;
use BplanBase\Globals\Models\TenantRecord;


/**
 * Update Action Class
 *
 * @version     1.0.0 / 2025-05-26
 * @author      Emilio Cannarozzo <emilio.cannarozzo@bplan-solutions.de>
 * @author      Wassilios Meletiadis <wassilios.meletiadis@bplan-solutions.de>
 */
class UpdateActiveStatus
{

/* +++ TRAITS +++ +++++++++++++++++++++++++++++++++++++++++++++++++++++++++++ */


/* +++ CLASS CONSTANTS +++ ++++++++++++++++++++++++++++++++++++++++++++++++++ */


/* +++ OBJECT MEMBERS +++ +++++++++++++++++++++++++++++++++++++++++++++++++++ */


/* +++ CLASS MEMBERS +++ ++++++++++++++++++++++++++++++++++++++++++++++++++++ */


/* +++ OBJECT METHODS +++ +++++++++++++++++++++++++++++++++++++++++++++++++++ */


    /**
     *
     * @param       int|string|TenantRecord|DerivedTenantRecord $tenantRecord
     *
     * @param       bool $status
     *
     * @return      TenantRecord|DerivedTenantRecord
     *
     * @version     1.0.0 / 2025-05-26
     * @author      Emilio Cannarozzo <emilio.cannarozzo@bplan-solutions.de>
     * @author      Wassilios Meletiadis <wassilios.meletiadis@bplan-solutions.de>
     */
    public function execute(int|string|TenantRecord|DerivedTenantRecord $tenantRecord, bool $status): TenantRecord|DerivedTenantRecord
    {
        if ($tenantRecord instanceof TenantRecord) {
            $Model = $tenantRecord;
        } else {
            $Model = TenantRecord::findOrFail($tenantRecord);
        }
        $Model->active = $status;

        $Model->save();

        return $Model;

    } // execute()


/* +++ CLASS METHODS +++ ++++++++++++++++++++++++++++++++++++++++++++++++++++ */


} // class UpdateActiveStatus {}
