<?php
/**
 * Repository Class
 *
 * @version     1.0.$Revision:$
 * @version     SVN: $Id:$
 * @generated   2025-05-24 21:12:04
 * @package     bplan-base/globals
 * @subpackage  Repositories
 * @author      Emilio Cannarozzo <emilio.cannarozzo@bplan-solutions.de>
 * @author      Wassilios Meletiadis <wassilios.meletiadis@bplan-solutions.de>
 * @copyright   Copyright (C) 2025 bplan-solutions GmbH & Co. KG <https://www.bplan-solutions.de/>
 * /Δ\
 */

namespace BplanBase\Globals\Repositories;


use App\Models\EntityType as DerivedEntityType;
use BplanBase\Globals\Helpers\EloquentHelper;
use BplanBase\Globals\Models\EntityType;
use BplanBase\Globals\Registries\Registry;
use Illuminate\Database\Eloquent\Builder;
use Illuminate\Database\Eloquent\Collection;


/**
 * Repository Class
 *
 * @version     3.0.0 / 2025-05-29
 * @author      Emilio Cannarozzo <emilio.cannarozzo@bplan-solutions.de>
 * @author      Wassilios Meletiadis <wassilios.meletiadis@bplan-solutions.de>
 */
class EntityTypeRepository
{


/* +++ TRAITS +++ +++++++++++++++++++++++++++++++++++++++++++++++++++++++++++ */


/* +++ CLASS CONSTANTS +++ ++++++++++++++++++++++++++++++++++++++++++++++++++ */


/* +++ OBJECT MEMBERS +++ +++++++++++++++++++++++++++++++++++++++++++++++++++ */


/* +++ CLASS MEMBERS +++ ++++++++++++++++++++++++++++++++++++++++++++++++++++ */


    /**
     * @var     string $_modelClass
     */
    protected static $_modelClass = \BplanBase\Globals\Models\EntityType::class;


/* +++ OBJECT METHODS +++ +++++++++++++++++++++++++++++++++++++++++++++++++++ */


/* +++ CLASS METHODS +++ ++++++++++++++++++++++++++++++++++++++++++++++++++++ */


    /**
     * Returns a collection of models
     *
     * @param       bool $ignoreCache
     *              Controls the use of the method cache when determining the result.
     *              If TRUE is passed, a database access is carried out even if the
     *              method cache already contains a suitable entry. The storage of
     *              a value in the method cache is not affected by this parameter.
     *
     * @param       array|string|null $orderBy
     *              @see BplanBase\Globals\Helpers\QueryHelper::applyOrderBy() for
     *              details.
     *
     * @param       bool $withInactive
     *              By default, only the active data records are returned. By
     *              setting this parameter to TRUE, the inactive data records can
     *              also be read out.
     *
     * @return      Collection
     *
     * @version     2.0.0 / 2025-05-25
     * @author      Emilio Cannarozzo <emilio.cannarozzo@bplan-solutions.de>
     * @author      Wassilios Meletiadis <wassilios.meletiadis@bplan-solutions.de>
     */
    public static function getAll(bool $ignoreCache = false, array|string|null $orderBy = null, bool $withInactive = false): Collection
    {
        static $cache = [];

        $cacheKey = md5(serialize(func_get_args()));

        if ($ignoreCache === false && isset($cache[$cacheKey])) {
            return $cache[$cacheKey];
        }
        $Query = static::$_modelClass::query();

        if ($withInactive === false) {
            $Query->active();
        }
        $Query->ordered($orderBy);

        return $cache[$cacheKey] = $Query->get();

    } // getAll()


    /**
     * Liefert eine Liste aller fremden EntityTypes, die dem übergebenen Tenant zur Verfügung stehen
     *
     * @todo        Auf die Verwendung von getSQLSelectFields() kann eigentlich verzichtet werden.
     *
     * @param       string $tenant_id
     *
     * @param       null|string $orderBy
     *
     * @return      Collection Liefert eine leere Collection, wenn es keine verfügbaren, fremden
     *              EntityTypes gibt.
     *
     * @version     3.1.0 / 2024-07-31
     * @author      Wassilios Meletiadis <wassilios.meletiadis@bplan-solutions.de>
     */
    public static function getAvailableEntityTypes(string $tenant_id, null|string $orderBy = null): Collection
    {
        $parentTenants = TenantRepository::determineParentTenantIDs($tenant_id);

        $Query = EntityType::whereIn('tenant_id', $parentTenants);

        if ($orderBy !== null) {
            $Query->orderBy($orderBy);
        }
        return $Query->get();

    } // getAvailableEntityTypes()


    /**
     * Returns the model instance for the given ID
     *
     * @param       int|string $id
     *
     * @param       bool $ignoreCache
     *              Controls the use of the method cache when determining the result.
     *              If TRUE is passed, a database access is carried out even if the method cache
     *              already contains a suitable entry. The storage of a value in the method cache
     *              is not affected by this parameter.
     *
     * @param       bool $returnOrFail
     *              Controls the return of the method.
     *              If no suitable entry can be found in the database, either NULL is returned (TRUE)
     *              or an exception is thrown (FALSE). This allows the result of the method call to
     *              be used directly in the Api controller.
     *
     * @throws      Illuminate\Database\Eloquent\ModelNotFoundException
     *
     * @return      EntityType|DerivedEntityType|null
     *
     * @version     2.0.0 / 2025-05-24
     * @author      Emilio Cannarozzo <emilio.cannarozzo@bplan-solutions.de>
     * @author      Wassilios Meletiadis <wassilios.meletiadis@bplan-solutions.de>
     */
    public static function getById(int|string $id, bool $ignoreCache = false, bool $returnOrFail = true): EntityType|DerivedEntityType|null
    {
        static $cache = [];

        $cacheKey = md5(serialize(func_get_args()));

        if ($ignoreCache === false && isset($cache[$cacheKey])) {
            return $cache[$cacheKey];
        }
        $Query = static::$_modelClass::query();

        if ($returnOrFail === true) {
            return $cache[$cacheKey] = $Query->find($id);
        }
        return $cache[$cacheKey] = $Query->findOrFail($id);

    } // getById()


    /**
     * Returns the model instance for the given UUID
     *
     * @param       string $uuid
     *
     * @param       bool $ignoreCache
     *              Controls the use of the method cache when determining the result.
     *              If TRUE is passed, a database access is carried out even if the method cache
     *              already contains a suitable entry. The storage of a value in the method cache
     *              is not affected by this parameter.
     *
     * @param       bool $returnOrFail
     *              Controls the return of the method.
     *              If no suitable entry can be found in the database, either NULL is returned (TRUE)
     *              or an exception is thrown (FALSE). This allows the result of the method call to
     *              be used directly in the Api controller.
     *
     * @throws      Illuminate\Database\Eloquent\ModelNotFoundException
     *
     * @return      EntityType|DerivedEntityType|null
     *
     * @version     1.0.0 / 2025-05-24
     * @author      Emilio Cannarozzo <emilio.cannarozzo@bplan-solutions.de>
     * @author      Wassilios Meletiadis <wassilios.meletiadis@bplan-solutions.de>
     */
    public static function getByUuid(int|string $uuid, bool $ignoreCache = false, bool $returnOrFail = true): EntityType|DerivedEntityType|null
    {
        static $cache = [];

        $cacheKey = md5(serialize(func_get_args()));

        if ($ignoreCache === false && isset($cache[$cacheKey])) {
            return $cache[$cacheKey];
        }
        $Query = static::$_modelClass::where('uuid', '=', $uuid);

        if ($returnOrFail === true) {
            return $cache[$cacheKey] = $Query->first();
        }
        return $cache[$cacheKey] = $Query->firstOrFail();

    } // getByUuid()


    /**
     * Liefert einen Array mit den Feldern des EntityTypes
     *
     * Für die Schlüssel des Arrays werden die Identifier der FieldDefinitions (FieldDefinition.identifier)
     * in Kleinschreibung verwendet, während die zugehörigen Werte den Feldnamen aus den FieldDefinitions
     * (FieldDefinition.storage) entsprechen.
     *
     * @param       string $entityTypeId
     *
     * @return      array Beispiel für den Aufbau des Ergebnisses:
     * <pre>
     *      array(
     *          "name" => "varVal001",
     *          "street" => "varVal002",
     *          ...
     *      )
     * </pre>
     *
     * @version     1.1.0 / 2024-06-08
     * @history     FieldDefinitionRepository::getFieldMap(), 1.1.0 / 2024-03-27
     * @author      Wassilios Meletiadis <wassilios.meletiadis@bplan-solutions.de>
     */
    public static function getFieldMap(string $entityTypeId): array
    {
        static $cache = [];

        $cacheKey = $entityTypeId;

        if (isset($cache[$cacheKey])) {
            return $cache[$cacheKey];
        }
        $FieldDefinitions = EntityTypeFieldRepository::getByEntityType($entityTypeId, withInactive: true);

        $fieldMap = [];

        foreach ($FieldDefinitions as $FieldDefinition) {
            $identifier = strtolower($FieldDefinition->identifier);

            $fieldMap[$identifier] = $FieldDefinition->storage;
        }
        return $cache[$cacheKey] = $fieldMap;

    } // getFieldMap()


    /**
     * Liefert den Identifier zur übergebenen EntityType-ID
     *
     * @param       string $entityTypeId
     *              Die ID zu einem EntityType.
     *
     * @return      EntityType
     *
     * @version     2.0.0 / 2024-07-31
     * @author      Wassilios Meletiadis <wassilios.meletiadis@bplan-solutions.de>
     */
    public static function getIdentifier(string $entityTypeId): string
    {
        static $cache = [];

        $cacheKey = md5(serialize(func_get_args()));

        if (isset($cache[$cacheKey])) {
            return $cache[$cacheKey];
        }
        $Result = EntityType::select('identifier')
            ->where('id', '=', $entityTypeId)
            ->first();

        return $cache[$cacheKey] = $Result->identifier;

    } // getIdentifier()


    /**
     * Liefert alle verknüpften EntityTypes zur übergebenen Tenant-ID
     *
     * @todo        Auf die Verwendung von getSQLSelectFields() kann eigentlich verzichtet werden.
     *
     * @param       string $tenant_id
     *
     * @param       null|string $orderBy
     *
     * @param       bool $withInactive
     *              By default, only the active data records are returned. By
     *              setting this parameter to TRUE, the inactive data records can
     *              also be read out.
     *
     * @return      Collection
     *
     * @version     1.0.0 / 2024-06-11
     * @author      Wassilios Meletiadis <wassilios.meletiadis@bplan-solutions.de>
     */
    public static function getLinkedEntityTypes(string $tenant_id, null|string $orderBy = null, bool $withInactive = false): Collection
    {
        static $cache = [];

        $cacheKey = md5(serialize(func_get_args()));

        if (isset($cache[$cacheKey])) {
            return $cache[$cacheKey];
        }
        $Query = EntityType::whereIn('id', EntityTypeTenantRepository::getEntityTypeIDs($tenant_id));

        if ($withInactive === false) {
            $Query->active();
        }
        if ($orderBy !== null) {
            $Query->orderBy($orderBy);
        }
        $Collection = $Query->get();

        return $cache[$cacheKey] = $Collection;

    } // getLinkedEntityTypes()


    /**
     * Returns an array with ID => label based on language code and fallback
     *
     * @param       string|null $locale
     *              If not given config('app.locale') is used.
     *
     * @param       bool $ignoreCache
     *              Controls the use of the method cache when determining the result.
     *              If TRUE is passed, a database access is carried out even if the method cache
     *              already contains a suitable entry. The storage of a value in the method cache
     *              is not affected by this parameter.
     *
     * @param       bool $withInactive
     *              By default, only the active data records are returned. By
     *              setting this parameter to TRUE, the inactive data records can
     *              also be read out.
     *
     * @return      array<string, string>
     *
     * @version     1.0.0 / 2025-05-29
     * @author      Wassilios Meletiadis <wassilios.meletiadis@bplan-solutions.de>
     */
    public static function getLocalizedList(string|null $locale = null, bool $ignoreCache = false, bool $withInactive = false): array
    {
        if ($locale === null) {
            $locale = config('app.locale');
        }
        static $cache = [];

        $cacheKey = md5(serialize(func_get_args()));

        if ($ignoreCache === false && isset($cache[$cacheKey])) {
            return $cache[$cacheKey];
        }
        $Query = static::$_modelClass::query();

        if ($withInactive === false) {
            $Query->active();
        }
        return $cache[$cacheKey] = EloquentHelper::getLocalizedCollection($Query, $locale, 'labels', fallbackAttribute: 'identifier')
            ->sort()
            ->toArray();

    } // getLocalizedList()


    /**
     * Liefert die Werte der mask-Felder des EntityTypes
     *
     * @param       string $entityTypeId
     *              Der ID zu einem EntityType.
     *
     * @return      array Liefert einen Array mit den Elementen "html" und "text".
     *
     * @version     2.0.0 / 2024-07-31
     * @author      Wassilios Meletiadis <wassilios.meletiadis@bplan-solutions.de>
     */
    public static function getMasks(string $entityTypeId): array
    {
        static $cache = [];

        $cacheKey = md5(serialize(func_get_args()));

        if (isset($cache[$cacheKey])) {
            return $cache[$cacheKey];
        }
        $Query = EntityType::selectRaw('htmlMask as html, textMask as text')
            ->where('id', '=', $entityTypeId);

        $Result = $Query->first();

        return $cache[$cacheKey] = $Result->toArray();

    } // getMasks()


    /**
     * Returns the Id for the given UUID
     *
     * @param       string $uuid
     *
     * @param       bool $returnOrFail
     *              Controls the return of the method.
     *              If no suitable entry can be found in the database, either NULL is returned (TRUE)
     *              or an exception is thrown (FALSE). This allows the result of the method call to
     *              be used directly in the Api controller.
     *
     * @throws      Illuminate\Database\Eloquent\ModelNotFoundException
     *
     * @return      int|null
     *
     * @version     2.0.0 / 2025-05-24
     * @author      Emilio Cannarozzo <emilio.cannarozzo@bplan-solutions.de>
     * @author      Wassilios Meletiadis <wassilios.meletiadis@bplan-solutions.de>
     */
    public static function getIdByUuid(string $uuid, bool $ignoreCache = false, bool $returnOrFail = true): int|null
    {
        static $cache = [];

        $cacheKey = md5(serialize(func_get_args()));

        if ($ignoreCache === false && isset($cache[$cacheKey])) {
            return $cache[$cacheKey];
        }
        $Query = static::$_modelClass::select('id')
            ->where('uuid', '=', $uuid);

        if ($returnOrFail === true) {
            $Model = $Query->first();

            if ($Model === null) {
                return null;
            }
            return $cache[$cacheKey] = $Model->id;
        }
        $Model = $Query->firstOrFail();

        return $cache[$cacheKey] = $Model->id;

    } // getIdByUuid()


    /**
     * Liefert alle eigenen oder verlinkten EntityTypes
     *
     * @param       bool $withInactive
     *              By default, only the active data records are returned. By
     *              setting this parameter to TRUE, the inactive data records can
     *              also be read out.
     *
     * @return      Collection
     *
     * @version     1.0.0 / 2024-07-31
     * @author      Wassilios Meletiadis <wassilios.meletiadis@bplan-solutions.de>
     */
    public static function getOwnAndLinkedEntityTypes(null|string $orderBy = null, bool $withInactive = false): Collection
    {
        static $cache = [];

        $cacheKey = md5(serialize(func_get_args()));

        if (isset($cache[$cacheKey])) {
            return $cache[$cacheKey];
        }
        $tenantId = Registry::get('tenantId');

        $Query = EntityType::where('tenant_id', '=', $tenantId)
            // ->orWhereIn('id', EntityTypeTenantRepository::getEntityTypeIds($tenantId))
            ;

        if ($withInactive === false) {
            $Query->active();
        }
        if ($orderBy !== null) {
            $Query->orderBy($orderBy);
        }
        $Collection = $Query->get();

        return $cache[$cacheKey] = $Collection;

    } // getOwnAndLinkedEntityTypes()


    /**
     * Liefert den EntityType zur übergebenen ID
     *
     * Die Methode liefert nur dann ein Ergebnis, wenn der EntityType zum aktuellen Tenant (own)
     * oder zu einem seiner Parent-Tenants (available) gehört. Wenn eine ungültige ID übergeben wird,
     * dann wird (durch die Methode firstOrFail()) eine ModelNotFound-Exception geworfen.
     *
     * @param       string $entityTypeId
     *              Die ID zu einem EntityType.
     *
     * @throws      ModelNotFoundException
     *
     * @return      EntityType Generiert einen Status 404, wenn kein passender EntityType ermittelt
     *              werden konnte.
     *
     * @version     1.0.0 / 2024-07-31
     * @author      Wassilios Meletiadis <wassilios.meletiadis@bplan-solutions.de>
     */
    public static function getOwnOrAvailableByID(string $entityTypeId): EntityType
    {
        static $cache = [];

        $cacheKey = md5(serialize(func_get_args()));

        if (isset($cache[$cacheKey])) {
            return $cache[$cacheKey];
        }
        $tenantId = Registry::get('tenantId');

        $availableEntityTypeIds = self::getAvailableEntityTypes($tenantId)
            ->pluck('id')
            ->toArray();
        /*
        **  Bedingung:  WHERE ID = ? AND (tenant_id = ? OR ID in (...))
        */
        $Query = EntityType::where('id', '=', $entityTypeId)
            ->where(function (Builder $Query) use ($availableEntityTypeIds, $tenantId) {
                $Query->where('tenant_id', '=', $tenantId)
                    // ->orWhereIn('id', $availableEntityTypeIds)
                    ;
            });

        return $cache[$cacheKey] = $Query->firstOrFail();

    } // getOwnOrAvailableByID()


    /**
     * Liefert den EntityType zur übergebenen ID
     *
     * Die Methode liefert nur dann ein Ergebnis, wenn der EntityType zum aktuellen Tenant (own)
     * gehört oder wenn er verknüpft (linked) ist. Wenn eine ungültige ID übergeben wird, dann
     * wird (durch die Methode firstOrFail()) eine ModelNotFound-Exception geworfen.
     *
     * @param       string $entityTypeId
     *              Die ID zu einem EntityType.
     *
     * @throws      ModelNotFoundException
     *
     * @return      EntityType Generiert einen Status 404, wenn kein passender EntityType ermittelt
     *              werden konnte.
     *
     * @version     1.0.0 / 2024-07-31
     * @author      Wassilios Meletiadis <wassilios.meletiadis@bplan-solutions.de>
     */
    public static function getOwnOrLinkedByID(string $entityTypeId): EntityType
    {
        static $cache = [];

        $cacheKey = md5(serialize(func_get_args()));

        if (isset($cache[$cacheKey])) {
            return $cache[$cacheKey];
        }
        $tenantId = Registry::get('tenantId');

        $availableEntityTypeIds = self::getAvailableEntityTypes($tenantId)
            ->pluck('id')
            ->toArray();
        /*
        **  Bedingung:  WHERE ID = ? AND (tenant_id = ? OR ID in (...))
        */
        $Query = EntityType::where('id', '=', $entityTypeId)
            ->where(function (Builder $Query) use ($availableEntityTypeIds, $tenantId) {
                $Query->where('tenant_id', '=', $tenantId)
                    // ->orWhereIn('id', EntityTypeTenantRepository::getEntityTypeIDs($tenantId))
                    ;
            });

        return $cache[$cacheKey] = $Query->firstOrFail();

    } // getOwnOrLinkedByID()


} // class EntityTypeRepository {}
