<?php
/**
 * Repository Class
 *
 * @version     1.0.$Revision:$
 * @version     SVN: $Id:$
 * @generated   2025-05-12 19:36:24
 * @package     bplan-base/globals
 * @subpackage  Repositories
 * @author      Emilio Cannarozzo <emilio.cannarozzo@bplan-solutions.de>
 * @author      Wassilios Meletiadis <wassilios.meletiadis@bplan-solutions.de>
 * @copyright   Copyright (C) 2025 bplan-solutions GmbH & Co. KG <https://www.bplan-solutions.de/>
 * /Δ\
 */

namespace BplanBase\Globals\Repositories;


use App\Models\User as DerivedUser;
use BplanBase\Globals\Models\User;
use BplanBase\Globals\Registries\Registry;
use BplanBase\Globals\Scopes\TenantScope;
use Illuminate\Database\Eloquent\Collection;


/**
 * Repository Class
 *
 * @version     4.2.0 / 2025-05-25
 * @author      Emilio Cannarozzo <emilio.cannarozzo@bplan-solutions.de>
 * @author      Wassilios Meletiadis <wassilios.meletiadis@bplan-solutions.de>
 */
class UserRepository
{


/* +++ TRAITS +++ +++++++++++++++++++++++++++++++++++++++++++++++++++++++++++ */


/* +++ CLASS CONSTANTS +++ ++++++++++++++++++++++++++++++++++++++++++++++++++ */


/* +++ OBJECT MEMBERS +++ +++++++++++++++++++++++++++++++++++++++++++++++++++ */


/* +++ CLASS MEMBERS +++ ++++++++++++++++++++++++++++++++++++++++++++++++++++ */


    /**
     * @var     string $_modelClass
     */
    protected static $_modelClass = \BplanBase\Globals\Models\User::class;


/* +++ OBJECT METHODS +++ +++++++++++++++++++++++++++++++++++++++++++++++++++ */


/* +++ CLASS METHODS +++ ++++++++++++++++++++++++++++++++++++++++++++++++++++ */


    /**
     * Returns a collection of models
     *
     * @param       bool $ignoreCache
     *              Controls the use of the method cache when determining the result.
     *              If TRUE is passed, a database access is carried out even if the method cache
     *              already contains a suitable entry. The storage of a value in the method cache
     *              is not affected by this parameter.
     *
     * @param       bool|int|string $ignoreRestriction
     *              By default, the result is limited to the users of the current tenant. The
     *              restriction can be removed by setting this parameter to TRUE. Alternatively,
     *              the ID of a tenant can also be transferred in order to determine its user.
     *
     * @param       array|string|null $orderBy
     *              @see BplanBase\Globals\Helpers\QueryHelper::applyOrderBy() for
     *              details.
     *
     * @param       bool $withInactive
     *              By default, only the active data records are returned. By setting this parameter
     *              to TRUE, the inactive data records can also be read out.
     *
     * @param       bool $withInternal
     *              By default, only the data records marked as “internal = 0” are read out. By
     *              setting this parameter to TRUE, the internal status is ignored and all data
     *              records are read.
     *
     * @return      Collection
     *
     * @version     3.0.0 / 2025-05-25
     * @author      Emilio Cannarozzo <emilio.cannarozzo@bplan-solutions.de>
     * @author      Wassilios Meletiadis <wassilios.meletiadis@bplan-solutions.de>
     */
    public static function getAll(bool $ignoreCache = false, bool|int|string $ignoreRestriction = false, array|string|null $orderBy = null, bool $withInactive = false, bool $withInternal = false): Collection
    {
        static $cache = [];

        $cacheKey = md5(serialize(func_get_args()));

        if ($ignoreCache === false && isset($cache[$cacheKey])) {
            return $cache[$cacheKey];
        }
        $Query = static::$_modelClass::query();

        if ($ignoreRestriction !== false) {
            $Query->withoutGlobalScope(TenantScope::class);

            if (!is_bool($ignoreRestriction)) {
                $Query->where('tenant_id', '=', $ignoreRestriction);
            }
        }
        if ($withInactive === false) {
            $Query->active();
        }
        if ($withInternal === false) {
            $Query->noInternal();
        }
        $Query->ordered($orderBy);

        return $cache[$cacheKey] = $Query->get();

    } // getAll()


    /**
     * Returns the model instance for the given email
     *
     * @param       string $email
     *
     * @param       bool $ignoreCache
     *              Controls the use of the method cache when determining the result.
     *              If TRUE is passed, a database access is carried out even if the method cache
     *              already contains a suitable entry. The storage of a value in the method cache
     *              is not affected by this parameter.
     *
     * @param       bool $ignoreRestriction
     *              By default, the result is limited to the users of the current tenant. The
     *              restriction can be removed by setting this parameter to TRUE.
     *
     * @param       bool $returnOrFail
     *              Controls the return of the method.
     *              If no suitable entry can be found in the database, either NULL is returned (TRUE)
     *              or an exception is thrown (FALSE). This allows the result of the method call to
     *              be used directly in the Api controller.
     *
     * @throws      Illuminate\Database\Eloquent\ModelNotFoundException
     *
     * @return      User|DerivedUser|null
     *
     * @version     2.0.0 / 2025-05-20
     * @author      Wassilios Meletiadis <wassilios.meletiadis@bplan-solutions.de>
     */
    public static function getByEmail(string $email, bool $ignoreCache = false, bool $ignoreRestriction = false, bool $returnOrFail = true): User|DerivedUser|null
    {
        static $cache = [];

        $cacheKey = md5(serialize(func_get_args()));

        if ($ignoreCache === false && isset($cache[$cacheKey])) {
            return $cache[$cacheKey];
        }
        $Query = static::$_modelClass::query();

        if ($ignoreRestriction === true) {
            $Query->withoutGlobalScope(TenantScope::class);
        }
        if ($returnOrFail === true) {
            return $cache[$cacheKey] = $Query->where('email', '=', $email)
                ->first();
        }
        return $cache[$cacheKey] = $Query->where('email', '=', $email)
            ->firstOrFail();

    } // getByEmail()


    /**
     * Returns the model instance for the given ID
     *
     * @param       int|string $id
     *
     * @param       bool $ignoreCache
     *              Controls the use of the method cache when determining the result.
     *              If TRUE is passed, a database access is carried out even if the method cache
     *              already contains a suitable entry. The storage of a value in the method cache
     *              is not affected by this parameter.
     *
     * @param       bool $ignoreRestriction
     *              By default, the result is limited to the tenants of the current user. The
     *              restriction can be removed by setting this parameter to TRUE.
     *
     * @param       bool $returnOrFail
     *              Controls the return of the method.
     *              If no suitable entry can be found in the database, either NULL is returned (TRUE)
     *              or an exception is thrown (FALSE). This allows the result of the method call to
     *              be used directly in the Api controller.
     *
     * @throws      Illuminate\Database\Eloquent\ModelNotFoundException
     *
     * @return      User|DerivedUser|null
     *
     * @version     3.0.0 / 2025-05-20
     * @author      Emilio Cannarozzo <emilio.cannarozzo@bplan-solutions.de>
     * @author      Wassilios Meletiadis <wassilios.meletiadis@bplan-solutions.de>
     */
    public static function getById(int|string $id, bool $ignoreCache = false, bool $ignoreRestriction = false, bool $returnOrFail = true): User|DerivedUser|null
    {
        static $cache = [];

        $cacheKey = md5(serialize(func_get_args()));

        if ($ignoreCache === false && isset($cache[$cacheKey])) {
            return $cache[$cacheKey];
        }
        $Query = static::$_modelClass::query();

        if ($ignoreRestriction === true) {
            $Query->withoutGlobalScope(TenantScope::class);
        }
        if ($returnOrFail === true) {
            return $cache[$cacheKey] = $Query->find($id);
        }
        return $cache[$cacheKey] = $Query->findOrFail($id);

    } // getById()


    /**
     * Returns the model instance for the given UUID
     *
     * @param       string $uuid
     *
     * @param       bool $ignoreCache
     *              Controls the use of the method cache when determining the result.
     *              If TRUE is passed, a database access is carried out even if the method cache
     *              already contains a suitable entry. The storage of a value in the method cache
     *              is not affected by this parameter.
     *
     * @param       bool $ignoreRestriction
     *              By default, the result is limited to the users of the current tenant. The
     *              restriction can be removed by setting this parameter to TRUE.
     *
     * @param       bool $returnOrFail
     *              Controls the return of the method.
     *              If no suitable entry can be found in the database, either NULL is returned (TRUE)
     *              or an exception is thrown (FALSE). This allows the result of the method call to
     *              be used directly in the Api controller.
     *
     * @throws      Illuminate\Database\Eloquent\ModelNotFoundException
     *
     * @return      User|DerivedUser|null
     *
     * @version     2.0.0 / 2025-05-20
     * @author      Emilio Cannarozzo <emilio.cannarozzo@bplan-solutions.de>
     * @author      Wassilios Meletiadis <wassilios.meletiadis@bplan-solutions.de>
     */
    public static function getByUuid(int|string $uuid, bool $ignoreCache = false, bool $ignoreRestriction = false, bool $returnOrFail = true): User|DerivedUser|null
    {
        static $cache = [];

        $cacheKey = md5(serialize(func_get_args()));

        if ($ignoreCache === false && isset($cache[$cacheKey])) {
            return $cache[$cacheKey];
        }
        $Query = static::$_modelClass::query();

        if ($ignoreRestriction === true) {
            $Query->withoutGlobalScope(TenantScope::class);
        }
        $Query->where('uuid', '=', $uuid);

        if ($returnOrFail === true) {
            return $cache[$cacheKey] = $Query->first();
        }
        return $cache[$cacheKey] = $Query->firstOrFail();

    } // getByUuid()


    /**
     * Returns the Id for the given UUID
     *
     * @param       string $uuid
     *
     * @param       bool $ignoreCache
     *              Controls the use of the method cache when determining the result.
     *              If TRUE is passed, a database access is carried out even if the method cache
     *              already contains a suitable entry. The storage of a value in the method cache
     *              is not affected by this parameter.
     *
     * @param       bool $ignoreRestriction
     *              By default, the result is limited to the users of the current tenant. The
     *              restriction can be removed by setting this parameter to TRUE.
     *
     * @param       bool $returnOrFail
     *              Controls the return of the method.
     *              If no suitable entry can be found in the database, either NULL is returned (TRUE)
     *              or an exception is thrown (FALSE). This allows the result of the method call to
     *              be used directly in the Api controller.
     *
     * @throws      Illuminate\Database\Eloquent\ModelNotFoundException
     *
     * @return      int|null
     *
     * @version     2.0.0 / 2025-05-20
     * @author      Emilio Cannarozzo <emilio.cannarozzo@bplan-solutions.de>
     * @author      Wassilios Meletiadis <wassilios.meletiadis@bplan-solutions.de>
     */
    public static function getIdByUuid(string $uuid, bool $ignoreCache = false, bool $ignoreRestriction = false, bool $returnOrFail = true): int|null
    {
        static $cache = [];

        $cacheKey = md5(serialize(func_get_args()));

        if ($ignoreCache === false && isset($cache[$cacheKey])) {
            return $cache[$cacheKey];
        }
        $Query = static::$_modelClass::select('id');

        if ($ignoreRestriction === true) {
            $Query->withoutGlobalScope(TenantScope::class);
        }
        $Query->where('uuid', '=', $uuid);

        if ($returnOrFail === true) {
            $Model = $Query->first();

            if ($Model === null) {
                return null;
            }
            return $cache[$cacheKey] = $Model->id;
        }
        $Model = $Query->firstOrFail();

        return $cache[$cacheKey] = $Model->id;

    } // getIdByUuid()


} // class UserRepository {}
