<?php
/**
 * Migration Class
 *
 * @version     1.0.$Revision:$
 * @version     SVN: $Id:$
 * @package     bplan-base/globals
 * @subpackage  Migrations
 * @author      Emilio Cannarozzo <emilio.cannarozzo@bplan-solutions.de>
 * @author      Wassilios Meletiadis <wassilios.meletiadis@bplan-solutions.de>
 * @copyright   Copyright (C) 2025 bplan-solutions GmbH & Co. KG <https://www.bplan-solutions.de/>
 * /Δ\
 */


use BplanBase\CodeGenerator\Loaders\CodeGenerator;
use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;


/**
 * Migration Class
 *
 * @author      Emilio Cannarozzo <emilio.cannarozzo@bplan-solutions.de>
 * @author      Wassilios Meletiadis <wassilios.meletiadis@bplan-solutions.de>
 */
return new class extends Migration
{

    /**
     * Reverse the migrations.
     *
     * @version     1.0.0 / 2024-05-22
     * @author      Wassilios Meletiadis <wassilios.meletiadis@bplan-solutions.de>
     */
    public function down(): void
    {
        Schema::dropIfExists('entity_type_tenant');

    } // down()


    /**
     * Run the migrations.
     *
     * @version     1.0.0 / 2024-05-22
     * @author      Wassilios Meletiadis <wassilios.meletiadis@bplan-solutions.de>
     */
    public function up(): void
    {
        Schema::create('entity_type_tenant', function (Blueprint $Table) {
            $Table->id();
            $Table->uuid('uuid');
            $Table->boolean('active')->default(1);

            $Table->timestamp('created_at');

            $Table->foreignId('entity_type_id')->constrained(table: 'entity_types', indexName: 'entity_type_tenant_FK_entity_type_id');
            $Table->foreignId('tenant_id')->constrained(table: 'tenants', indexName: 'entity_type_tenant_FK_tenant_id');

            $Table->index('entity_type_id', 'entity_type_tenant_FKI_entity_type_id');
            $Table->index('tenant_id',      'entity_type_tenant_FKI_tenant_id');

            new CodeGenerator($Table, [
                'exclude' => [
                    'laravel.action.update',
                ],
                'pivot' => [
                    'relations' => [
                        'entity_type_id' => 'entity_types',
                        'tenant_id' => 'tenants',
                    ],
                ],
                'routing' => [
                    'terminal' => 'readOnly',
                ],
                'traits' => [
                    'laravel.model' => [
                        'BplanBase\\Globals\Traits\\HasActiveScope',
                        'BplanBase\\Globals\Traits\\HasOrderedScope',
                    ],
                ],
            ]);

        });
    } // up()

};
