<?php
/**
 * Admin Controller Class
 *
 * @version     1.0.$Revision:$
 * @version     SVN: $Id:$
 * @package     bplan-base/globals
 * @subpackage  Controllers
 * @author      Wassilios Meletiadis <wassilios.meletiadis@bplan-solutions.de>
 * @copyright   Copyright (C) 2025 Wassilios Meletiadis <https://www.bplan-solutions.de/>
 * /Δ\
 */

namespace BplanBase\Globals\Http\Controllers\Core;


use BplanBase\Globals\Livewire\Core\TenantModules\Form as TenantModuleForm;
use BplanBase\Globals\Livewire\Core\TenantModules\Grid as TenantModuleGrid;
use BplanBase\Globals\Models\TenantModule;
use BplanBase\Globals\Repositories\TenantModuleRepository;
use BplanBase\Globals\Services\TenantModuleService;
use Illuminate\Http\Request;


/**
 * Admin Controller Class
 *
 * @version     1.0.0 / 2025-05-25
 * @author      Wassilios Meletiadis <wassilios.meletiadis@bplan-solutions.de>
 */
class TenantModuleController extends BaseController
{

/* +++ TRAITS +++ +++++++++++++++++++++++++++++++++++++++++++++++++++++++++++ */


/* +++ CLASS CONSTANTS +++ ++++++++++++++++++++++++++++++++++++++++++++++++++ */


/* +++ OBJECT MEMBERS +++ +++++++++++++++++++++++++++++++++++++++++++++++++++ */


    /**
     * @var     string $_modelClass
     */
    protected string $_formClass = TenantModuleForm::class;


    /**
     * @var     string $_modelClass
     */
    protected string $_gridClass = TenantModuleGrid::class;


    /**
     * @var     string $_modelClass
     */
    protected string $_modelClass = TenantModule::class;


    /**
     * @var     string $_repositoryClass
     */
    protected string $_repositoryClass = TenantModuleRepository::class;


    /**
     * @var     string $_resourceName
     */
    protected string $_resourceName = 'tenant-modules';


/* +++ CLASS MEMBERS +++ ++++++++++++++++++++++++++++++++++++++++++++++++++++ */


/* +++ OBJECT METHODS +++ +++++++++++++++++++++++++++++++++++++++++++++++++++ */


    /**
     *
     * @param       Request $Request
     *
     * @param       TenantModuleService $Service
     *
     * @version     1.0.0 / 2025-05-25
     * @author      Wassilios Meletiadis <wassilios.meletiadis@bplan-solutions.de>
     */
    public function __construct(Request $Request, TenantModuleService $Service)
    {
        parent::__construct($Request, $Service);

    } // __construct()


    // /**
    //  * Show the form for editing the specified resource.
    //  *
    //  * @return      \Illuminate\Http\Response
    //  *
    //  * @version     1.0.0 / 2025-05-25
    //  * @author      Wassilios Meletiadis <wassilios.meletiadis@bplan-solutions.de>
    //  */
    // public function index()
    // {
    //     return view('livewire.grid-container', [
    //         'Collection' => $this->_Repository->getAll(),
    //         'modelClass' => $this->_modelClass,
    //         'resourceName' => $this->_resourceName,
    //         'serviceClass' => $this->_Service::class,
    //     ]);
    // } // index()


/* +++ CLASS METHODS +++ ++++++++++++++++++++++++++++++++++++++++++++++++++++ */


} // class TenantModuleController extends BaseController {}
