<?php
/**
 * Observer Class
 *
 * @version     1.0.$Revision:$
 * @version     SVN: $Id:$
 * @generated   2025-05-20 17:09:29
 * @package     bplan-base/globals
 * @subpackage  Observers
 * @author      Emilio Cannarozzo <emilio.cannarozzo@bplan-solutions.de>
 * @author      Wassilios Meletiadis <wassilios.meletiadis@bplan-solutions.de>
 * @copyright   Copyright (C) 2025 bplan-solutions GmbH & Co. KG <https://www.bplan-solutions.de/>
 * /Δ\
 */

namespace BplanBase\Globals\Observers;


use App\Models\TenantUser as DerivedTenantUser;
use BplanBase\Globals\Models\TenantUser;
use BplanBase\Globals\Registries\Registry;
use Illuminate\Support\Str;


/**
 * Observer Class
 *
 * @version     1.1.0 / 2025-05-20
 * @author      Emilio Cannarozzo <emilio.cannarozzo@bplan-solutions.de>
 * @author      Wassilios Meletiadis <wassilios.meletiadis@bplan-solutions.de>
 */
class TenantUserObserver
{


/* +++ TRAITS +++ +++++++++++++++++++++++++++++++++++++++++++++++++++++++++++ */


/* +++ CLASS CONSTANTS +++ ++++++++++++++++++++++++++++++++++++++++++++++++++ */


    /**
     * @var     string MODEL_CLASS
     */
    const MODEL_CLASS = TenantUser::class;


/* +++ OBJECT MEMBERS +++ +++++++++++++++++++++++++++++++++++++++++++++++++++ */


/* +++ CLASS MEMBERS +++ ++++++++++++++++++++++++++++++++++++++++++++++++++++ */


/* +++ OBJECT METHODS +++ +++++++++++++++++++++++++++++++++++++++++++++++++++ */


    /**
     * Handle the Models "created" event
     *
     * When a new model is saved for the first time, the creating and created
     * events will dispatch.
     *
     * @param       TenantUser|DerivedTenantUser $Model
     *
     * @return      void
     *
     * @version     1.0.0 / 2025-05-20
     * @author      Emilio Cannarozzo <emilio.cannarozzo@bplan-solutions.de>
     * @author      Wassilios Meletiadis <wassilios.meletiadis@bplan-solutions.de>
     */
    public function created(TenantUser|DerivedTenantUser $Model): void
    {
        //
    } // created()


    /**
     * Handle the Models "creating" event
     *
     * When a new model is saved for the first time, the creating and created
     * events will dispatch.
     *
     * @param       TenantUser|DerivedTenantUser $Model
     *
     * @return      void
     *
     * @version     1.0.0 / 2025-05-20
     * @author      Emilio Cannarozzo <emilio.cannarozzo@bplan-solutions.de>
     * @author      Wassilios Meletiadis <wassilios.meletiadis@bplan-solutions.de>
     */
    public function creating(TenantUser|DerivedTenantUser $Model): void
    {
        $tenantId = Registry::get('tenantId');

        $Model->tenant_id = $tenantId;
        $Model->uuid = Str::uuid();

    } // creating()


    /**
     * Handle the Models "deleted" event
     *
     * @param       TenantUser|DerivedTenantUser $Model
     *
     * @return      void
     *
     * @version     1.0.0 / 2025-05-20
     * @author      Emilio Cannarozzo <emilio.cannarozzo@bplan-solutions.de>
     * @author      Wassilios Meletiadis <wassilios.meletiadis@bplan-solutions.de>
     */
    public function deleted(TenantUser|DerivedTenantUser $Model): void
    {
        //
    } // deleted()


    /**
     * Handle the Models "deleting" event
     *
     * @param       TenantUser|DerivedTenantUser $Model
     *
     * @return      void
     *
     * @version     1.0.0 / 2025-05-20
     * @author      Emilio Cannarozzo <emilio.cannarozzo@bplan-solutions.de>
     * @author      Wassilios Meletiadis <wassilios.meletiadis@bplan-solutions.de>
     */
    public function deleting(TenantUser|DerivedTenantUser $Model): void
    {
        //
    } // deleting()


    /**
     * Handle the Models "forceDeleted" event
     *
     * @param       TenantUser|DerivedTenantUser $Model
     *
     * @return      void
     *
     * @version     1.0.0 / 2025-05-20
     * @author      Emilio Cannarozzo <emilio.cannarozzo@bplan-solutions.de>
     * @author      Wassilios Meletiadis <wassilios.meletiadis@bplan-solutions.de>
     */
    public function forceDeleted(TenantUser|DerivedTenantUser $Model): void
    {
        //
    } // forceDeleted()


    /**
     * Handle the Models "forceDeleting" event
     *
     * @param       TenantUser|DerivedTenantUser $Model
     *
     * @return      void
     *
     * @version     1.0.0 / 2025-05-20
     * @author      Emilio Cannarozzo <emilio.cannarozzo@bplan-solutions.de>
     * @author      Wassilios Meletiadis <wassilios.meletiadis@bplan-solutions.de>
     */
    public function forceDeleting(TenantUser|DerivedTenantUser $Model): void
    {
        //
    } // forceDeleting()


    /**
     * Handle the Models "replicating" event
     *
     * @param       TenantUser|DerivedTenantUser $Model
     *
     * @return      void
     *
     * @version     1.0.0 / 2025-05-20
     * @author      Emilio Cannarozzo <emilio.cannarozzo@bplan-solutions.de>
     * @author      Wassilios Meletiadis <wassilios.meletiadis@bplan-solutions.de>
     */
    public function replicating(TenantUser|DerivedTenantUser $Model): void
    {
        //
    } // replicating()


    /**
     * Handle the Models "restored" event
     *
     * @param       TenantUser|DerivedTenantUser $Model
     *
     * @return      void
     *
     * @version     1.0.0 / 2025-05-20
     * @author      Emilio Cannarozzo <emilio.cannarozzo@bplan-solutions.de>
     * @author      Wassilios Meletiadis <wassilios.meletiadis@bplan-solutions.de>
     */
    public function restored(TenantUser|DerivedTenantUser $Model): void
    {
        //
    } // restored()


    /**
     * Handle the Models "restoring" event
     *
     * @param       TenantUser|DerivedTenantUser $Model
     *
     * @return      void
     *
     * @version     1.0.0 / 2025-05-20
     * @author      Emilio Cannarozzo <emilio.cannarozzo@bplan-solutions.de>
     * @author      Wassilios Meletiadis <wassilios.meletiadis@bplan-solutions.de>
     */
    public function restoring(TenantUser|DerivedTenantUser $Model): void
    {
        //
    } // restoring()


    /**
     * Handle the Models "retrieved" event
     *
     * The retrieved event will dispatch when an existing model is retrieved
     * from the database.
     *
     * @param       TenantUser|DerivedTenantUser $Model
     *
     * @return      void
     *
     * @version     1.0.0 / 2025-05-20
     * @author      Emilio Cannarozzo <emilio.cannarozzo@bplan-solutions.de>
     * @author      Wassilios Meletiadis <wassilios.meletiadis@bplan-solutions.de>
     */
    public function retrieved(TenantUser|DerivedTenantUser $Model): void
    {
        //
    } // retrieved()


    /**
     * Handle the Models "saved" event
     *
     * The saving / saved events will dispatch when a model is created or
     * updated - even if the model's attributes have not been changed.
     *
     * @param       TenantUser|DerivedTenantUser $Model
     *
     * @return      void
     *
     * @version     1.0.0 / 2025-05-20
     * @author      Emilio Cannarozzo <emilio.cannarozzo@bplan-solutions.de>
     * @author      Wassilios Meletiadis <wassilios.meletiadis@bplan-solutions.de>
     */
    public function saved(TenantUser|DerivedTenantUser $Model): void
    {
        //
    } // saved()


    /**
     * Handle the Models "saving" event
     *
     * The saving / saved events will dispatch when a model is created or
     * updated - even if the model's attributes have not been changed.
     *
     * @param       TenantUser|DerivedTenantUser $Model
     *
     * @return      void
     *
     * @version     1.0.0 / 2025-05-20
     * @author      Emilio Cannarozzo <emilio.cannarozzo@bplan-solutions.de>
     * @author      Wassilios Meletiadis <wassilios.meletiadis@bplan-solutions.de>
     */
    public function saving(TenantUser|DerivedTenantUser $Model): void
    {
        //
    } // saving()


    /**
     * Handle the Models "trashed" event
     *
     * @param       TenantUser|DerivedTenantUser $Model
     *
     * @return      void
     *
     * @version     1.0.0 / 2025-05-20
     * @author      Emilio Cannarozzo <emilio.cannarozzo@bplan-solutions.de>
     * @author      Wassilios Meletiadis <wassilios.meletiadis@bplan-solutions.de>
     */
    public function trashed(TenantUser|DerivedTenantUser $Model): void
    {
        //
    } // trashed()


    /**
     * Handle the Models "updated" event
     *
     * The updating / updated events will dispatch when an existing model is
     * modified and the save method is called.
     *
     * @param       TenantUser|DerivedTenantUser $Model
     *
     * @return      void
     *
     * @version     1.0.0 / 2025-05-20
     * @author      Emilio Cannarozzo <emilio.cannarozzo@bplan-solutions.de>
     * @author      Wassilios Meletiadis <wassilios.meletiadis@bplan-solutions.de>
     */
    public function updated(TenantUser|DerivedTenantUser $Model): void
    {
        //
    } // updated()


    /**
     * Handle the Models "updating" event
     *
     * The updating / updated events will dispatch when an existing model is
     * modified and the save method is called.
     *
     * @param       TenantUser|DerivedTenantUser $Model
     *
     * @return      void
     *
     * @version     1.0.0 / 2025-05-20
     * @author      Emilio Cannarozzo <emilio.cannarozzo@bplan-solutions.de>
     * @author      Wassilios Meletiadis <wassilios.meletiadis@bplan-solutions.de>
     */
    public function updating(TenantUser|DerivedTenantUser $Model): void
    {
        unset($Model->tenant_id);
        unset($Model->uuid);

    } // updating()


/* +++ CLASS METHODS +++ ++++++++++++++++++++++++++++++++++++++++++++++++++++ */


} // class TenantUserObserver {}
