<?php
/**
 * Repository Class
 *
 * @version     1.0.$Revision:$
 * @version     SVN: $Id:$
 * @generated   2025-05-24 22:00:19
 * @package     bplan-base/globals
 * @subpackage  Repositories
 * @author      Emilio Cannarozzo <emilio.cannarozzo@bplan-solutions.de>
 * @author      Wassilios Meletiadis <wassilios.meletiadis@bplan-solutions.de>
 * @copyright   Copyright (C) 2025 bplan-solutions GmbH & Co. KG <https://www.bplan-solutions.de/>
 * /Δ\
 */

namespace BplanBase\Globals\Repositories;


use App\Models\EntityTypeTenant as DerivedEntityTypeTenant;
use BplanBase\Globals\Models\EntityTypeTenant;
use Illuminate\Database\Eloquent\Collection;


/**
 * Repository Class
 *
 * @version     2.2.0 / 2025-05-25
 * @author      Emilio Cannarozzo <emilio.cannarozzo@bplan-solutions.de>
 * @author      Wassilios Meletiadis <wassilios.meletiadis@bplan-solutions.de>
 */
class EntityTypeTenantRepository
{


/* +++ TRAITS +++ +++++++++++++++++++++++++++++++++++++++++++++++++++++++++++ */


/* +++ CLASS CONSTANTS +++ ++++++++++++++++++++++++++++++++++++++++++++++++++ */


/* +++ OBJECT MEMBERS +++ +++++++++++++++++++++++++++++++++++++++++++++++++++ */


/* +++ CLASS MEMBERS +++ ++++++++++++++++++++++++++++++++++++++++++++++++++++ */


    /**
     * @var     string $_modelClass
     */
    protected static $_modelClass = \BplanBase\Globals\Models\EntityTypeTenant::class;


/* +++ OBJECT METHODS +++ +++++++++++++++++++++++++++++++++++++++++++++++++++ */


/* +++ CLASS METHODS +++ ++++++++++++++++++++++++++++++++++++++++++++++++++++ */


    /**
     * Returns a collection of models
     *
     * @param       bool $ignoreCache
     *              Controls the use of the method cache when determining the result.
     *              If TRUE is passed, a database access is carried out even if the
     *              method cache already contains a suitable entry. The storage of
     *              a value in the method cache is not affected by this parameter.
     *
     * @param       array|string|null $orderBy
     *              @see BplanBase\Globals\Helpers\QueryHelper::applyOrderBy() for
     *              details.
     *
     * @param       bool $withInactive
     *              By default, only the active data records are returned. By
     *              setting this parameter to TRUE, the inactive data records can
     *              also be read out.
     *
     * @return      Collection
     *
     * @version     2.0.0 / 2025-05-25
     * @author      Emilio Cannarozzo <emilio.cannarozzo@bplan-solutions.de>
     * @author      Wassilios Meletiadis <wassilios.meletiadis@bplan-solutions.de>
     */
    public static function getAll(bool $ignoreCache = false, array|string|null $orderBy = null, bool $withInactive = false): Collection
    {
        static $cache = [];

        $cacheKey = md5(serialize(func_get_args()));

        if ($ignoreCache === false && isset($cache[$cacheKey])) {
            return $cache[$cacheKey];
        }
        $Query = static::$_modelClass::query();

        if ($withInactive === false) {
            $Query->active();
        }
        $Query->ordered($orderBy);

        return $cache[$cacheKey] = $Query->get();

    } // getAll()


    /**
     * Returns the model instance for the given ID
     *
     * @param       int|string $id
     *
     * @param       bool $ignoreCache
     *              Controls the use of the method cache when determining the result.
     *              If TRUE is passed, a database access is carried out even if the method cache
     *              already contains a suitable entry. The storage of a value in the method cache
     *              is not affected by this parameter.
     *
     * @param       bool $returnOrFail
     *              Controls the return of the method.
     *              If no suitable entry can be found in the database, either NULL is returned (TRUE)
     *              or an exception is thrown (FALSE). This allows the result of the method call to
     *              be used directly in the Api controller.
     *
     * @throws      Illuminate\Database\Eloquent\ModelNotFoundException
     *
     * @return      EntityTypeTenant|DerivedEntityTypeTenant|null
     *
     * @version     2.0.0 / 2025-05-24
     * @author      Emilio Cannarozzo <emilio.cannarozzo@bplan-solutions.de>
     * @author      Wassilios Meletiadis <wassilios.meletiadis@bplan-solutions.de>
     */
    public static function getById(int|string $id, bool $ignoreCache = false, bool $returnOrFail = true): EntityTypeTenant|DerivedEntityTypeTenant|null
    {
        static $cache = [];

        $cacheKey = md5(serialize(func_get_args()));

        if ($ignoreCache === false && isset($cache[$cacheKey])) {
            return $cache[$cacheKey];
        }
        $Query = static::$_modelClass::query();

        if ($returnOrFail === true) {
            return $cache[$cacheKey] = $Query->find($id);
        }
        return $cache[$cacheKey] = $Query->findOrFail($id);

    } // getById()


    /**
     * Returns the model instance for the given UUID
     *
     * @param       string $uuid
     *
     * @param       bool $ignoreCache
     *              Controls the use of the method cache when determining the result.
     *              If TRUE is passed, a database access is carried out even if the method cache
     *              already contains a suitable entry. The storage of a value in the method cache
     *              is not affected by this parameter.
     *
     * @param       bool $returnOrFail
     *              Controls the return of the method.
     *              If no suitable entry can be found in the database, either NULL is returned (TRUE)
     *              or an exception is thrown (FALSE). This allows the result of the method call to
     *              be used directly in the Api controller.
     *
     * @throws      Illuminate\Database\Eloquent\ModelNotFoundException
     *
     * @return      EntityTypeTenant|DerivedEntityTypeTenant|null
     *
     * @version     1.0.0 / 2025-05-24
     * @author      Emilio Cannarozzo <emilio.cannarozzo@bplan-solutions.de>
     * @author      Wassilios Meletiadis <wassilios.meletiadis@bplan-solutions.de>
     */
    public static function getByUuid(int|string $uuid, bool $ignoreCache = false, bool $returnOrFail = true): EntityTypeTenant|DerivedEntityTypeTenant|null
    {
        static $cache = [];

        $cacheKey = md5(serialize(func_get_args()));

        if ($ignoreCache === false && isset($cache[$cacheKey])) {
            return $cache[$cacheKey];
        }
        $Query = static::$_modelClass::where('uuid', '=', $uuid);

        if ($returnOrFail === true) {
            return $cache[$cacheKey] = $Query->first();
        }
        return $cache[$cacheKey] = $Query->firstOrFail();

    } // getByUuid()


    /**
     * Liefert einen Array mit den IDs der ererbten EntityTypes
     *
     * @param       string $tenantId
     *
     * @return      array
     *
     * @version     2.0.0 / 2024-06-11
     * @author      Wassilios Meletiadis <wassilios.meletiadis@bplan-solutions.de>
     */
    public static function getEntityTypeIds(string $tenantId): array
    {
        static $cache = [];

        $cacheKey = md5(serialize(func_get_args()));

        if (isset($cache[$cacheKey])) {
            return $cache[$cacheKey];
        }
        $result = EntityTypeTenant::select('entity_type_id')
            ->where('tenant_id', '=', $tenantId)
            ->get()
            ->pluck('entity_type_id')
            ->toArray();

        return $cache[$cacheKey] = $result;

    } // getEntityTypeIds()


    /**
     * Liefert die ID zu einer Relation
     *
     * @param       int|string $tenant_id
     *
     * @param       int|string $entityTypeId
     *
     * @param       bool $returnOrFail
     *              Controls the return of the method.
     *              If no suitable entry can be found in the database, either NULL is returned (TRUE)
     *              or an exception is thrown (FALSE). This allows the result of the method call to
     *              be used directly in the Api controller.
     *
     * @return      int|null Die ID zur Verknüpfung oder NULL wenn keine Verknüpfung gefunden werden
     *              konnte.
     *
     * @version     1.0.0 / 2025-05-27
     * @author      Wassilios Meletiadis <wassilios.meletiadis@bplan-solutions.de>
     */
    public static function getId(int|string $tenant_id, int|string $entityTypeId, bool $returnOrFail = true): int|null
    {
        static $cache = [];

        $cacheKey = md5(serialize(func_get_args()));

        if (isset($cache[$cacheKey])) {
            return $cache[$cacheKey];
        }
        $Query = static::$_modelClass::select('id')
            ->where('tenant_id', '=', $tenant_id)
            ->where('entity_type_id', '=', $entityTypeId);

        if ($returnOrFail === true) {
            $Model = $Query->first();

            if ($Model === null) {
                return null;
            }
            return $cache[$cacheKey] = $Model->id;
        }
        $Model = $Query->firstOrFail();

        return $cache[$cacheKey] = $Model->id;

    } // getId()


    /**
     * Returns the Id for the given UUID
     *
     * @param       string $uuid
     *
     * @param       bool $returnOrFail
     *              Controls the return of the method.
     *              If no suitable entry can be found in the database, either NULL is returned (TRUE)
     *              or an exception is thrown (FALSE). This allows the result of the method call to
     *              be used directly in the Api controller.
     *
     * @throws      Illuminate\Database\Eloquent\ModelNotFoundException
     *
     * @return      int|null
     *
     * @version     2.0.0 / 2025-05-24
     * @author      Emilio Cannarozzo <emilio.cannarozzo@bplan-solutions.de>
     * @author      Wassilios Meletiadis <wassilios.meletiadis@bplan-solutions.de>
     */
    public static function getIdByUuid(string $uuid, bool $ignoreCache = false, bool $returnOrFail = true): int|null
    {
        static $cache = [];

        $cacheKey = md5(serialize(func_get_args()));

        if ($ignoreCache === false && isset($cache[$cacheKey])) {
            return $cache[$cacheKey];
        }
        $Query = static::$_modelClass::select('id')
            ->where('uuid', '=', $uuid);

        if ($returnOrFail === true) {
            $Model = $Query->first();

            if ($Model === null) {
                return null;
            }
            return $cache[$cacheKey] = $Model->id;
        }
        $Model = $Query->firstOrFail();

        return $cache[$cacheKey] = $Model->id;

    } // getIdByUuid()


} // class EntityTypeTenantRepository {}
