<?php
/**
 * Rule Class
 *
 * @version     1.0.$Revision:$
 * @version     SVN: $Id:$
 * @package     bplan-base/globals
 * @subpackage  Rules
 * @author      Wassilios Meletiadis <wassilios.meletiadis@bplan-solutions.de>
 * @copyright   Copyright (C) 2025 bplan-solutions GmbH & Co. KG <https://www.bplan-solutions.de/>
 * /Δ\
 */

namespace BplanBase\Globals\Rules;


use Closure;
use Illuminate\Contracts\Validation\Rule;


/**
 * Rule Class
 *
 * Stellt sicher, dass mindestens eins der beiden involvierten Felder einen Wert enthält.
 *
 * todo         Illuminate\Contracts\Validation\Rule ist deprecated. Stattdessen sollte Illuminate\Contracts\Validation\ValidationRule verwendet werden.
 *
 * @version     1.0.0 / 2025-03-25
 * @author      Wassilios Meletiadis <wassilios.meletiadis@bplan-solutions.de>
 */
class RequiredIfEmpty implements Rule
{


/* +++ TRAITS +++ +++++++++++++++++++++++++++++++++++++++++++++++++++++++++++ */


/* +++ CLASS CONSTANTS +++ ++++++++++++++++++++++++++++++++++++++++++++++++++ */


/* +++ OBJECT MEMBERS +++ +++++++++++++++++++++++++++++++++++++++++++++++++++ */


    /**
     * @var     string $_attribute
     */
    protected $_attribute;


    /**
     * @var     array $_dataSet
     */
    protected $_dataSet;


    /**
     * @var     string $_otherField
     */
    protected $_otherField;


/* +++ CLASS MEMBERS +++ ++++++++++++++++++++++++++++++++++++++++++++++++++++ */


/* +++ OBJECT METHODS +++ +++++++++++++++++++++++++++++++++++++++++++++++++++ */


    /**
     *
     * @param       string $otherField
     *              Der Name des jeweils anderen Feldes.
     *
     * @param       array $dataSet
     *              Der vollständige Datensatz als assoziativer Array.
     *
     * @version     1.0.0 / 2025-03-25
     * @author      Wassilios Meletiadis <wassilios.meletiadis@bplan-solutions.de>
     */
    public function __construct(string $otherField, array $dataSet)
    {
        $this->_otherField = $otherField;
        $this->_dataSet = $dataSet;

    } // __construct()


    /**
     *
     * @return 	    string
     *
     * @version     1.0.0 / 2025-03-25
     * @author      Wassilios Meletiadis <wassilios.meletiadis@bplan-solutions.de>
     */
    public function message()
    {
        return __('validation.required_if_empty', [
            'attribute' => $this->_attribute,
            'other' => $this->_otherField
        ]);
    } // message()


    /**
     *
     * @param       $attribute
     *              Der Name des zu überprüfenden Feldes.
     *
     * @param       $value
     *              Der Wert des zu überprüfenden Feldes.
     *
     * @return 	    bool
     *
     * @version     1.0.0 / 2025-03-25
     * @author      Wassilios Meletiadis <wassilios.meletiadis@bplan-solutions.de>
     */
    public function passes($attribute, $value)
    {
        if (strpos($attribute, '.') !== false) {
            /*
            **  Bei der Verwendung mit Laravel Excel besteht der Attributname aus dem Zeilenindex und dem
            **  Spaltennamen, die durch einen Punkt miteinander verbunden sind. Um den realen Namen des
            **  Attributs zu ermitteln, muss der Zeilenindex entfernt werden. */
            list($nul, $this->_attribute) = explode('.', $attribute);
        } else {
            $this->_attribute = $attribute;
        }
        $otherValue = $this->_dataSet[$this->_otherField] ?? null;

        return !empty($value) || !empty($otherValue);

    } // passes()


/* +++ CLASS METHODS +++ ++++++++++++++++++++++++++++++++++++++++++++++++++++ */


} // class RequiredIfEmpty implements Rule {}
