<?php
/**
 *
 * @version     1.0.$Revision:$
 * @version     SVN: $Id:$
 * @package     bplan-base/globals
 * @subpackage  Locales
 * @author      Emilio Cannarozzo <emilio.cannarozzo@bplan-solutions.de>
 * @author      Wassilios Meletiadis <wassilios.meletiadis@bplan-solutions.de>
 * @copyright   Copyright (C) 2025 bplan-solutions GmbH & Co. KG <http://www.bplan-solutions.de/>
 * /Δ\
 */


use Carbon\WeekDay;


return [

    'iso-3166-1-alpha-2' => 'es',
    'language' => 'Español',
    'locale' => 'es_ES',

    'currency.decimals'        => "2",
    'currency.format.string'   => ':value €',
    'currency.format.negative' => '-:value €',
    'currency.iso4217.alpha'   => 'EUR',
    'currency.iso4217.numeric' => 978,
    'currency.name'            => 'Euro',
    'currency.subunit.divisor' => 100,
    'currency.subunit.name'    => 'Céntimo',
    'currency.subunit.symbol'  => '¢',
    'currency.symbol'          => '€',

    'date.format'       => 'd/m/Y',
    'datetime.format'   => 'd/m/Y H:i',
    'datetime.format+'  => 'd/m/Y H:i:s',
    'datetime.format-+' => 'd/m/Y H:i',
    'datetime.format++' => 'd/m/Y H:i:s',
    'time.format'       => 'H:i',
    'time.format+'      => 'H:i:s',
    'time.format-+'     => 'H:i',
    'time.format++'     => 'H:i:s',

    'number.decimal-point'       => ',',
    'number.thousands-separator' => '.',

    'text.direction'    => 'ltr',
    'text.orientation'  => 'sideways',
    'text.writing-mode' => 'vertical-rl',

    // -------------------------------------------------------------------

    'action.activate'      => 'Activar',
    'action.add'           => 'Añadir',
    'action.cancel'        => 'Cancelar',
    'action.cancel-upload' => 'Cancelar subida',
    'action.change'        => 'Cambiar',
    'action.close'         => 'Cerrar',
    'action.confirm'       => 'Confirmar',
    'action.deactivate'    => 'Desactivar',
    'action.delete'        => 'Eliminar',
    'action.edit'          => 'Editar',
    'action.import'        => 'Importar',
    'action.print'         => 'Imprimir',
    'action.save'          => 'Guardar',
    'action.search'        => 'Buscar',
    'action.sync'          => 'Sincronizar',
    'action.upload'        => 'Subir archivo',
    'action.verify'        => 'Verificar',
    'action.view'          => 'Ver',

    'languages' => [
        'bg' => 'Búlgaro',
        'de' => 'Alemán',
        'en' => 'Inglés',
        'es' => 'Español',
        'fr' => 'Francés',
        'hu' => 'Húngaro',
        'it' => 'Italiano',
        'lt' => 'Lituano',
        'pl' => 'Polaco',
        'ro' => 'Rumano',
        'ru' => 'Ruso',
        'tr' => 'Turco',
        'uk' => 'Ucraniano',
    ],

    'option.yes' => 'Sí',
    'option.no'  => 'No',

    'required-hint'   => 'Los campos marcados (<span class="required-marker">:marker</span>) son obligatorios',
    'required-marker' => '*',

    'select-option.no-options-available' => 'No hay opciones',
    'select-option.please-select'        => ' -- Por favor, seleccione -- ',

    'status.active'   => 'Activo',
    'status.expired'  => 'Expirado',
    'status.inactive' => 'Inactivo',
    'status.invalid'  => 'Inválido',
    'status.loading'  => 'Cargando...',
    'status.not-set'  => 'No establecido',
    'status.valid'    => 'Válido',

    'weekdays.'.Weekday::Sunday->name    => 'domingo',
    'weekdays.'.Weekday::Monday->name    => 'lunes',
    'weekdays.'.Weekday::Tuesday->name   => 'martes',
    'weekdays.'.Weekday::Wednesday->name => 'miércoles',
    'weekdays.'.Weekday::Thursday->name  => 'jueves',
    'weekdays.'.Weekday::Friday->name    => 'viernes',
    'weekdays.'.Weekday::Saturday->name  => 'sábado',

    'weekdays.'.Weekday::Sunday->value    => 'domingo',
    'weekdays.'.Weekday::Monday->value    => 'lunes',
    'weekdays.'.Weekday::Tuesday->value   => 'martes',
    'weekdays.'.Weekday::Wednesday->value => 'miércoles',
    'weekdays.'.Weekday::Thursday->value  => 'jueves',
    'weekdays.'.Weekday::Friday->value    => 'viernes',
    'weekdays.'.Weekday::Saturday->value  => 'sábado',

];
