<?php
/**
 * Model Class
 *
 * @version     1.0.$Revision:$
 * @version     SVN: $Id:$
 * @generated   2025-05-23 11:19:17
 * @package     bplan-base/globals
 * @subpackage  Models
 * @author      Emilio Cannarozzo <emilio.cannarozzo@bplan-solutions.de>
 * @author      Wassilios Meletiadis <wassilios.meletiadis@bplan-solutions.de>
 * @copyright   Copyright (C) 2025 bplan-solutions GmbH & Co. KG <https://www.bplan-solutions.de/>
 * /Δ\
 */

namespace BplanBase\Globals\Models;


use BplanBase\Globals\Observers\TenantLocaleObserver;
use BplanBase\Globals\Scopes\TenantScope;
use BplanBase\Globals\Traits\HasActiveScope;
use BplanBase\Globals\Traits\HasOrderedScope;
use Illuminate\Database\Eloquent\Attributes\ObservedBy;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Relations\BelongsTo;


/**
 * Model Class
 *
 * @version     1.4.0 / 2025-05-23
 * @author      Emilio Cannarozzo <emilio.cannarozzo@bplan-solutions.de>
 * @author      Wassilios Meletiadis <wassilios.meletiadis@bplan-solutions.de>
 */
#[ObservedBy([TenantLocaleObserver::class])]
class TenantLocale extends Model
{


/* +++ TRAITS +++ +++++++++++++++++++++++++++++++++++++++++++++++++++++++++++ */


    use HasActiveScope;
    use HasOrderedScope;


/* +++ CLASS CONSTANTS +++ ++++++++++++++++++++++++++++++++++++++++++++++++++ */


    /**
     *
     */
    const UPDATED_AT = null;


/* +++ OBJECT MEMBERS +++ +++++++++++++++++++++++++++++++++++++++++++++++++++ */


    /**
     * The accessors to append to the model's array form.
     *
     * @var         array<int, string> $appends
     *
     * @version     1.0.0 / 2025-05-23
     */
    protected $appends = [];


    /**
     * @var         array<string, string> $casts
     *
     * @version     1.0.0 / 2025-05-23
     */
    protected $casts = [
        'active'     => 'boolean',
        'created_at' => 'datetime',
    ];


    /**
     * The attributes that are mass assignable.
     *
     * @var         array<int, string> $fillable
     *
     * @version     1.0.0 / 2025-05-23
     */
    protected $fillable = [
        'active',
        'key_index',
        'locale',
        'main',
    ];


    /**
     * The attributes that aren't mass assignable.
     *
     * @var         array<int, string> $guarded
     *
     * @version     1.0.0 / 2025-05-23
     */
    protected $guarded = [
        'created_at',
        'tenant_id',
        'uuid',
    ];


    /**
     * The attributes that should be hidden for serialization.
     *
     * @var         array<int, string> $hidden
     *
     * @version     1.0.0 / 2025-05-23
     */
    protected $hidden = [];


    /**
     * The table associated with the model.
     *
     * @var         string $table
     */
    protected $table = 'tenant_locales';


    /**
     * Indicates if the model should be timestamped.
     *
     * @var         bool $timestamps
     */
    public $timestamps = true;


/* +++ CLASS MEMBERS +++ ++++++++++++++++++++++++++++++++++++++++++++++++++++ */


/* +++ OBJECT METHODS +++ +++++++++++++++++++++++++++++++++++++++++++++++++++ */


    /**
     *
     * @return      void
     *
     * @version     1.0.0 / 2025-05-20
     * @author      Wassilios Meletiadis <wassilios.meletiadis@bplan-solutions.de>
     */
    protected static function booted(): void
    {
        static::addGlobalScope(new TenantScope());

    } // booted()


    /**
     *
     * @return      BelongsTo
     *
     * @version     1.0.0 / 2025-05-23
     * @author      Emilio Cannarozzo <emilio.cannarozzo@bplan-solutions.de>
     * @author      Wassilios Meletiadis <wassilios.meletiadis@bplan-solutions.de>
     */
    public function tenant(): BelongsTo
    {
        return $this->belongsTo(Tenant::class, 'tenant_id');

    } // tenant()


/* +++ CLASS METHODS +++ ++++++++++++++++++++++++++++++++++++++++++++++++++++ */


} // class TenantLocale extends Model {}
