<?php
/**
 * Migration Class
 *
 * @version     1.0.$Revision:$
 * @version     SVN: $Id:$
 * @package     bplan-base/globals
 * @subpackage  Migrations
 * @author      Emilio Cannarozzo <emilio.cannarozzo@bplan-solutions.de>
 * @author      Wassilios Meletiadis <wassilios.meletiadis@bplan-solutions.de>
 * @copyright   Copyright (C) 2025 bplan-solutions GmbH & Co. KG <https://www.bplan-solutions.de/>
 * /Δ\
 */


use BplanBase\CodeGenerator\Loaders\CodeGenerator;
use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;


/**
 * Migration Class
 *
 * @author      Emilio Cannarozzo <emilio.cannarozzo@bplan-solutions.de>
 * @author      Wassilios Meletiadis <wassilios.meletiadis@bplan-solutions.de>
 */
return new class extends Migration
{

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('user_records');

    } // down()


    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('user_records', function (Blueprint $Table) {
            $Table->foreignId('id')->constrained(table: 'users', indexName: 'user_records_PK');
            $Table->uuid('uuid');

            $Table->timestamp('created_at');
            $Table->softDeletes('deleted_at');
            $Table->timestamp('updated_at');

            $Table->string('email', 255);
            $Table->string('first_name', 50)->nullable();
            $Table->string('last_name', 50)->nullable();

            $Table->unique('id',   'user_records_UKI_id');
            $Table->unique('uuid', 'user_records_UKI_uuid');

            new CodeGenerator($Table, [
                'columns' => [
                    'id' => [
                        'relationName' => 'user',
                        'reverseRelationType' => 'HasOne',
                    ],
                    'active' => [
                        'sortable' => true,
                    ],
                    'email' => [
                        'ruleType' => 'email',
                        'sortable' => true,
                    ],
                    'last_name' => [
                        'sortable' => true,
                    ],
                ],
                'routing' => [
                    'terminal' => 'readOnly',
                ],
                'traits' => [
                    'laravel.model' => [
                        'BplanBase\\Globals\Traits\\HasOrderedScope',
                    ],
                ],
            ]);

        });
    } // up()

};
