<?php
/**
 *
 * @version     1.0.$Revision:$
 * @version     SVN: $Id:$
 * @package     bplan-base/globals
 * @subpackage  Seeders
 * @author      Wassilios Meletiadis <wassilios.meletiadis@bplan-solutions.de>
 * @copyright   Copyright (C) 2025 bplan-solutions GmbH & Co. KG <https://www.bplan-solutions.de/>
 * /Δ\
 */

namespace BplanBase\Globals\Database\Seeders\Dev;


use BplanBase\Globals\Models\Module;
use BplanBase\Globals\Repositories\ExternalSystemRepository;
use BplanBase\Globals\Repositories\TenantRepository;
use Illuminate\Database\Seeder;
use Illuminate\Support\Facades\DB;
use Illuminate\Support\Str;


/**
 *
 * @author      Wassilios Meletiadis <wassilios.meletiadis@bplan-solutions.de>
 */
class TenantExternalSystemSeeder extends Seeder
{

    /**
     * Run the database seeds.
     *
     * @return void
     *
     * @author      Wassilios Meletiadis <wassilios.meletiadis@bplan-solutions.de>
     */
    public function run()
    {
        $date = date('Y-m-d H:i:s');

        $Tenant = TenantRepository::getByIdentifier('System', ignoreRestriction: true);

        $ExternalSystemAD = ExternalSystemRepository::getByIdentifier('AD');
        $ExternalSystemAzure = ExternalSystemRepository::getByIdentifier('Azure');

        $keyIndex = 0;

        DB::table('tenant_external_systems')->insert([
            [
                'uuid' => Str::uuid(),
                'active' => 1,
                'created_at' => $date,
                'updated_at' => $date,
                'external_system_id' => $ExternalSystemAD->id,
                'identifier' => 'AD 1',
                'key_index' => ++$keyIndex,
                'label' => 'Custom AD',
                'tenant_id' => $Tenant->id,
            ], [
                'uuid' => Str::uuid(),
                'active' => 1,
                'created_at' => $date,
                'updated_at' => $date,
                'external_system_id' => $ExternalSystemAzure->id,
                'identifier' => 'Azure',
                'key_index' => ++$keyIndex,
                'label' => 'Custom Azure Cloud',
                'tenant_id' => $Tenant->id,
            ],

        ]);

    } // run()

} // class TenantExternalSystemSeeder extends Seeder {}
