<?php
/**
 * Copy Action Class
 *
 * @version     1.0.$Revision:$
 * @version     SVN: $Id:$
 * @package     bplan-base/globals
 * @subpackage  Actions
 * @author      Emilio Cannarozzo <emilio.cannarozzo@bplan-solutions.de>
 * @author      Wassilios Meletiadis <wassilios.meletiadis@bplan-solutions.de>
 * @copyright   Copyright (C) 2025 bplan-solutions GmbH & Co. KG <https://www.bplan-solutions.de/>
 * /Δ\
 */

namespace BplanBase\Globals\Actions\EntityType;


use App\Models\EntityType as DerivedEntityType;
use BplanBase\Globals\Models\EntityType;
use BplanBase\Globals\Registries\Registry;
use BplanBase\Globals\Repositories\EntityTypeFieldRepository;
use BplanBase\Globals\Services\EntityTypeFieldService;
use Illuminate\Support\Facades\DB;
use Illuminate\Support\Str;


/**
 * Copy Action Class
 *
 * @version     1.0.0 / 2025-05-29
 * @author      Wassilios Meletiadis <wassilios.meletiadis@bplan-solutions.de>
 */
class Copy
{

/* +++ TRAITS +++ +++++++++++++++++++++++++++++++++++++++++++++++++++++++++++ */


/* +++ CLASS CONSTANTS +++ ++++++++++++++++++++++++++++++++++++++++++++++++++ */


/* +++ OBJECT MEMBERS +++ +++++++++++++++++++++++++++++++++++++++++++++++++++ */


/* +++ CLASS MEMBERS +++ ++++++++++++++++++++++++++++++++++++++++++++++++++++ */


/* +++ OBJECT METHODS +++ +++++++++++++++++++++++++++++++++++++++++++++++++++ */


    /**
     * Kopiert einen EntityType und gibt den neuen EntityType zurück
     *
     * @param       int|string|EntityType|DerivedEntityType $entityType
     *
     * @return      EntityTEntityType|DerivedEntityTypeype
     *
     * @version     1.0.0 / 2025-05-29
     * @author      Wassilios Meletiadis <wassilios.meletiadis@bplan-solutions.de>
     */
    public function execute(int|string|EntityType|DerivedEntityType $entityType): EntityType|DerivedEntityType
    {
        if ($entityType instanceof EntityType) {
            $Source = $entityType;
        } else {
            $Source = EntityType::findOrFail($entityType);
        }
        $Model = $Source->replicate(['deleted', 'tenant_id', 'uuid']);

        DB::transaction(function () use ($Model, $Source) {
            $rand = Str::random(6);
            /*
            **  Kopie des EntityTypes erstellen und speichern. */
            $Model->abstract = false;
            $Model->master_id = $Source->id;
            $Model->resource_name .= '-'.strtolower($rand);
            $Model->sub_type .= ucfirst(strtolower($rand));
            $Model->tenant_id = Registry::get('tenantId');

            if ($Model->source_id === null) {
                $Model->source_id = $Source->id;
            }
            $Model->save();
            /*
            **  Fields zum EntityType abarbeiten und kopieren. */
            $Fields = EntityTypeFieldRepository::getByEntityType($Source);

            $EntityTypeFieldService = new EntityTypeFieldService();

            foreach ($Fields as $Field) {
                $EntityTypeFieldService->copy($Field->id, $Model->id);
            }
        });
        return $Model;

    } // execute()


} // Copy {}
