<?php
/**
 * Admin Controller Class
 *
 * @version     1.0.$Revision:$
 * @version     SVN: $Id:$
 * @package     bplan-base/globals
 * @subpackage  Controllers
 * @author      Wassilios Meletiadis <wassilios.meletiadis@bplan-solutions.de>
 * @copyright   Copyright (C) 2025 Wassilios Meletiadis <https://www.bplan-solutions.de/>
 * /Δ\
 */

namespace BplanBase\Globals\Http\Controllers\Core;


use BplanBase\Globals\Livewire\Core\Modules\Form as ModuleForm;
use BplanBase\Globals\Livewire\Core\Modules\Grid as ModuleGrid;
use BplanBase\Globals\Models\Module;
use BplanBase\Globals\Repositories\ModuleRepository;
use BplanBase\Globals\Services\ModuleService;
use Illuminate\Http\Request;


/**
 * Admin Controller Class
 *
 * @version     1.0.0 / 2025-05-25
 * @author      Wassilios Meletiadis <wassilios.meletiadis@bplan-solutions.de>
 */
class ModuleController extends BaseController
{

/* +++ TRAITS +++ +++++++++++++++++++++++++++++++++++++++++++++++++++++++++++ */


/* +++ CLASS CONSTANTS +++ ++++++++++++++++++++++++++++++++++++++++++++++++++ */


/* +++ OBJECT MEMBERS +++ +++++++++++++++++++++++++++++++++++++++++++++++++++ */


    /**
     * @var     string $_modelClass
     */
    protected string $_formClass = ModuleForm::class;


    /**
     * @var     string $_modelClass
     */
    protected string $_gridClass = ModuleGrid::class;


    /**
     * @var     string $_modelClass
     */
    protected string $_modelClass = Module::class;


    /**
     * @var     string $_repositoryClass
     */
    protected string $_repositoryClass = ModuleRepository::class;


    /**
     * @var     string $_resourceName
     */
    protected string $_resourceName = 'modules';


/* +++ CLASS MEMBERS +++ ++++++++++++++++++++++++++++++++++++++++++++++++++++ */


/* +++ OBJECT METHODS +++ +++++++++++++++++++++++++++++++++++++++++++++++++++ */


    /**
     *
     * @param       Request $Request
     *
     * @param       ModuleService $Service
     *
     * @version     1.0.0 / 2025-05-25
     * @author      Wassilios Meletiadis <wassilios.meletiadis@bplan-solutions.de>
     */
    public function __construct(Request $Request, ModuleService $Service)
    {
        parent::__construct($Request, $Service);

    } // __construct()


/* +++ CLASS METHODS +++ ++++++++++++++++++++++++++++++++++++++++++++++++++++ */


} // class ModuleController extends BaseController {}
