<?php
/**
 * Admin Controller Class
 *
 * @version     1.0.$Revision:$
 * @version     SVN: $Id:$
 * @package     bplan-base/globals
 * @subpackage  Controllers
 * @author      Wassilios Meletiadis <wassilios.meletiadis@bplan-solutions.de>
 * @copyright   Copyright (C) 2025 Wassilios Meletiadis <https://www.bplan-solutions.de/>
 * /Δ\
 */

namespace BplanBase\Globals\Http\Controllers\Core;


use BplanBase\Globals\Livewire\Core\TenantRecords\Form as TenantRecordForm;
use BplanBase\Globals\Livewire\Core\TenantRecords\Grid as TenantRecordGrid;
use BplanBase\Globals\Models\TenantRecord;
use BplanBase\Globals\Repositories\TenantRecordRepository;
use BplanBase\Globals\Services\TenantRecordService;
use Illuminate\Http\Request;


/**
 * Admin Controller Class
 *
 * @version     1.0.0 / 2025-05-25
 * @author      Wassilios Meletiadis <wassilios.meletiadis@bplan-solutions.de>
 */
class TenantRecordController extends BaseController
{

/* +++ TRAITS +++ +++++++++++++++++++++++++++++++++++++++++++++++++++++++++++ */


/* +++ CLASS CONSTANTS +++ ++++++++++++++++++++++++++++++++++++++++++++++++++ */


/* +++ OBJECT MEMBERS +++ +++++++++++++++++++++++++++++++++++++++++++++++++++ */


    /**
     * @var     string $_modelClass
     */
    protected string $_formClass = TenantRecordForm::class;


    /**
     * @var     string $_modelClass
     */
    protected string $_gridClass = TenantRecordGrid::class;


    /**
     * @var     string $_modelClass
     */
    protected string $_modelClass = TenantRecord::class;


    /**
     * @var     string $_repositoryClass
     */
    protected string $_repositoryClass = TenantRecordRepository::class;


    /**
     * @var     string $_resourceName
     */
    protected string $_resourceName = 'tenant-records';


/* +++ CLASS MEMBERS +++ ++++++++++++++++++++++++++++++++++++++++++++++++++++ */


/* +++ OBJECT METHODS +++ +++++++++++++++++++++++++++++++++++++++++++++++++++ */


    /**
     *
     * @param       Request $Request
     *
     * @param       TenantRecordService $Service
     *
     * @version     1.0.0 / 2025-05-25
     * @author      Wassilios Meletiadis <wassilios.meletiadis@bplan-solutions.de>
     */
    public function __construct(Request $Request, TenantRecordService $Service)
    {
        parent::__construct($Request, $Service);

    } // __construct()


    /**
     * Überschreibt die Methode der Base-Klasse
     *
     * Neue TenantRecords werden automatisch angelegt wenn ein neuer Tenant angelegt wird. Deshalb
     * leitet diese Methode auf die Neuanlage für Tenants um.
     *
     * @return      \Illuminate\Http\Response
     *
     * @version     1.0.0 / 2025-05-25
     * @author      Wassilios Meletiadis <wassilios.meletiadis@bplan-solutions.de>
     */
    public function create()
    {
        return redirect()->route('create.tenant');

    } // create()


    /**
     * Überschreibt die Methode der Base-Klasse
     *
     * TenantRecords können nur gelöscht werden indem der zugehörige Tenant gelöscht wird. Deshalb
     * leitet diese Methode auf die Löschung für Tenants um.
     *
     * @param       int  $id
     *
     * @return      \Illuminate\Http\Response
     *
     * @version     1.0.0 / 2025-05-25
     * @author      Wassilios Meletiadis <wassilios.meletiadis@bplan-solutions.de>
     */
    public function destroy($id)
    {
        return redirect()->route('delete.tenant', ['id' => $id]);

    } // destroy()


    /**
     *
     * @return 	    void
     *
     * @version     1.0.0 / 2025-05-25
     * @author      Wassilios Meletiadis <wassilios.meletiadis@bplan-solutions.de>
     */
    public function index()
    {
        $this->_Collection = TenantRecordRepository::getAll(withInactive: true);

        return parent::index();

    } // index()


/* +++ CLASS METHODS +++ ++++++++++++++++++++++++++++++++++++++++++++++++++++ */


} // class TenantRecordController extends BaseController {}
