<?php #CodeGenerator Δ 6d569f47b1e07ae8663cb086037138fd Δ DYNAMICALLY GENERATED FILE - Do not modify this line! Remove it completely to protect the file from changes.
/**
 * JSON:API Schema Class
 *
 * @version     1.0.$Revision:$
 * @version     SVN: $Id:$
 * @generated   2025-05-13 08:27:58
 * @package     bplan-base/globals
 * @subpackage  Schemas
 * @author      Emilio Cannarozzo <emilio.cannarozzo@bplan-solutions.de>
 * @author      Wassilios Meletiadis <wassilios.meletiadis@bplan-solutions.de>
 * @copyright   Copyright (C) 2025 bplan-solutions GmbH & Co. KG <https://www.bplan-solutions.de/>
 * /Δ\
 */

namespace BplanBase\Globals\JsonApi\Terminal\Users;


use BplanBase\Globals\Models\User;
use Carbon\Carbon;
use Illuminate\Database\Eloquent\Builder;
use Illuminate\Http\Request;
use LaravelJsonApi\Eloquent\Contracts\Paginator;
use LaravelJsonApi\Eloquent\Fields\Boolean;
use LaravelJsonApi\Eloquent\Fields\DateTime;
use LaravelJsonApi\Eloquent\Fields\ID;
use LaravelJsonApi\Eloquent\Fields\Number;
use LaravelJsonApi\Eloquent\Fields\Relations\BelongsTo;
use LaravelJsonApi\Eloquent\Fields\Relations\HasMany;
use LaravelJsonApi\Eloquent\Fields\Relations\HasOne;
use LaravelJsonApi\Eloquent\Fields\Str;
use LaravelJsonApi\Eloquent\Filters\WhereIdIn;
use LaravelJsonApi\Eloquent\Pagination\PagePagination;
use LaravelJsonApi\Eloquent\Schema;


/**
 * JSON:API Schema Class
 *
 * @version     2.2.0 / 2025-05-13
 * @author      Emilio Cannarozzo <emilio.cannarozzo@bplan-solutions.de>
 * @author      Wassilios Meletiadis <wassilios.meletiadis@bplan-solutions.de>
 */
class UserSchema extends Schema
{


/* +++ TRAITS +++ +++++++++++++++++++++++++++++++++++++++++++++++++++++++++++ */


/* +++ CLASS CONSTANTS +++ ++++++++++++++++++++++++++++++++++++++++++++++++++ */


/* +++ OBJECT MEMBERS +++ +++++++++++++++++++++++++++++++++++++++++++++++++++ */


    /**
     * The maximum include path depth.
     *
     * @var int
     */
    protected int $maxDepth = 2;


/* +++ CLASS MEMBERS +++ ++++++++++++++++++++++++++++++++++++++++++++++++++++ */


    /**
     * The model the schema corresponds to.
     *
     * @var         string
     */
    public static string $model = User::class;


/* +++ OBJECT METHODS +++ +++++++++++++++++++++++++++++++++++++++++++++++++++ */


    /**
     * Get the resource fields.
     *
     * @return      array
     *
     * @version     1.3.0 / 2025-05-13
     * @author      Emilio Cannarozzo <emilio.cannarozzo@bplan-solutions.de>
     * @author      Wassilios Meletiadis <wassilios.meletiadis@bplan-solutions.de>
     */
    public function fields(): array
    {

        $timezone = config('app.timezone');

        return [
            ID::make(),

            Boolean::make('active')->sortable(),
            DateTime::make('createdAt')->serializeUsing(
                static fn($value) => $value ? Carbon::parse($value)->setTimezone($timezone)->format('c') : null
            )->readOnly()->sortable(),

            DateTime::make('deletedAt')->serializeUsing(
                static fn($value) => $value ? Carbon::parse($value)->setTimezone($timezone)->format('c') : null
            )->readOnly()->sortable(),

            DateTime::make('updatedAt')->serializeUsing(
                static fn($value) => $value ? Carbon::parse($value)->setTimezone($timezone)->format('c') : null
            )->readOnly()->sortable(),

            Str::make('uuid')->readOnly()->sortable(),

            Str::make('accessLevel'),
            Number::make('currentTeamId'),
            Str::make('email')->sortable(),
            DateTime::make('emailVerifiedAt')->serializeUsing(
                static fn($value) => $value ? Carbon::parse($value)->setTimezone($timezone)->format('c') : null
            ),

            Boolean::make('internal')->sortable(),
            Str::make('name')->sortable(),
            Str::make('password')->hidden(),
            Str::make('profilePhotoPath'),
            Str::make('rememberToken')->hidden(),
            Boolean::make('restricted'),
            /*
            **  Appended fields */
            Str::make('profilePhotoUrl'),
            /*
            **  Relations */
            HasMany::make('roles')->type('roles')->serializeUsing(
                static fn($Relation) => $Relation->alwaysShowData()
            ),
            BelongsTo::make('tenant')->type('tenants')->serializeUsing(
                static fn($Relation) => $Relation->alwaysShowData()
            ),
            HasMany::make('tenants')->type('tenants')->serializeUsing(
                static fn($Relation) => $Relation->alwaysShowData()
            ),
            HasOne::make('user-record')->type('user-records')->serializeUsing(
                static fn($Relation) => $Relation->alwaysShowData()
            ),

        ];
    } // fields()


    /**
     * Get the resource filters.
     *
     * @return      array
     *
     * @version     1.0.0 / 2025-05-13
     * @author      Emilio Cannarozzo <emilio.cannarozzo@bplan-solutions.de>
     * @author      Wassilios Meletiadis <wassilios.meletiadis@bplan-solutions.de>
     */
    public function filters(): array
    {
        return [
            WhereIdIn::make($this),
        ];
    } // filters()


    /**
     * Build an index query for this resource.
     *
     * @param       Request|null $Request
     *
     * @param       Builder $Query
     *
     * @return      Builder

     * @version     1.0.0 / 2025-05-13
     * @author      Emilio Cannarozzo <emilio.cannarozzo@bplan-solutions.de>
     * @author      Wassilios Meletiadis <wassilios.meletiadis@bplan-solutions.de>
     */
    public function indexQuery(?Request $Request, Builder $Query): Builder
    {
        return $Query->where(function (Builder $Query) {
            return $Query->where('active', '=', 1);
        });
    } // indexQuery()


    /**
     * Get the resource paginator.
     *
     * @return      null|Paginator
     *
     * @version     1.0.0 / 2025-05-13
     * @author      Emilio Cannarozzo <emilio.cannarozzo@bplan-solutions.de>
     * @author      Wassilios Meletiadis <wassilios.meletiadis@bplan-solutions.de>
     */
    public function pagination(): ?Paginator
    {
        return PagePagination::make();

    } // pagination()


/* +++ CLASS METHODS +++ ++++++++++++++++++++++++++++++++++++++++++++++++++++ */


} // class UserSchema extends Schema {}
