<?php
/**
 *
 * @version     1.0.$Revision:$
 * @version     SVN: $Id:$
 * @package     bplan-base/globals
 * @subpackage  LivewireComponents
 * @author      Wassilios Meletiadis <wassilios.meletiadis@bplan-solutions.de>
 * @copyright   Copyright (C) 2025 Wassilios Meletiadis <https://www.bplan-solutions.de/>
 * /Δ\
 */

namespace BplanBase\Globals\Livewire\Core\EntityTypes;


use BplanBase\Globals\Livewire\Core\Global\BaseGrid;
use BplanBase\Globals\Registries\Registry;
use BplanBase\Globals\Repositories\EntityTypeRepository;
use BplanBase\Globals\Repositories\EntityTypeTenantRepository;
use BplanBase\Globals\Repositories\TenantRepository;


/**
 *
 * @version     1.0.0 / 2025-05-25
 * @author      Wassilios Meletiadis <wassilios.meletiadis@bplan-solutions.de>
 */
class Grid extends BaseGrid
{


/* +++ TRAITS +++ +++++++++++++++++++++++++++++++++++++++++++++++++++++++++++ */


/* +++ CLASS CONSTANTS +++ ++++++++++++++++++++++++++++++++++++++++++++++++++ */


/* +++ OBJECT MEMBERS +++ +++++++++++++++++++++++++++++++++++++++++++++++++++ */


    /**
     * @var     Collection $AvailableEntityTypes
     */
    public $AvailableEntityTypes;


    /**
     * @var     array $linkedEntityTypeIDs
     */
    public $linkedEntityTypeIDs;


    /**
     * @var     Collection $LinkedEntityTypes
     */
    public $LinkedEntityTypes;


    /**
     * @var     string $selectedTab
     */
    public $selectedTab = 'base';


    /**
     * @var         array $tabs
     * @version     1.0.0 / 2025-05-25
     */
    public $tabs = [
        'base',
        // 'linked',
        'foreign',
    ];


    /**
     * @var     array $tenants
     */
    public $tenants;


/* +++ CLASS MEMBERS +++ ++++++++++++++++++++++++++++++++++++++++++++++++++++ */


/* +++ OBJECT METHODS +++ +++++++++++++++++++++++++++++++++++++++++++++++++++ */


    /**
     *
     * @version     1.0.0 / 2025-05-25
     * @author      Wassilios Meletiadis <wassilios.meletiadis@bplan-solutions.de>
     */
    protected function _initEntityTypes(): void
    {
        $tenantId = Registry::get('tenantId');
        /*
        **  Identifier aller verwendeten EntityTypes ermitteln um prüfen zu können ob es einen
        **  Konflikt mit dem Identifer des zu kopierenden EntityType gibt.  */
        $AllEntityTypes = EntityTypeRepository::getOwnAndLinkedEntityTypes(withInactive: true);

        $usedIdentifiers = array_flip(array_map('strtolower', $AllEntityTypes->pluck('identifier')
            ->toArray()));

        $this->AvailableEntityTypes = EntityTypeRepository::getAvailableEntityTypes($tenantId);

        if ($this->AvailableEntityTypes->isEmpty()) {
            $this->tabs['foreign']['active'] = false;
        }
//  Nachfolgender Code war dazu gedacht die fremden EntityTypes herauszufiltern, deren Identifier
//  mit einem eigenen oder einem verlinkten EntityType kollidiert. Das führt aber dazu, dass bereits
//  verlinkte EntityTypes nicht mehr in der Liste der fremden EntityTypes aufgeführt werden.
//        else {
//            foreach ($this->AvailableEntityTypes as $key => $EntityType) {
//                $lowerIdentifier = strtolower($EntityType->identifier);
//
//                if (isset($usedIdentifiers[$lowerIdentifier])) {
//                    $this->AvailableEntityTypes->forget($key);
//                }
//            }
//            if ($this->AvailableEntityTypes->isEmpty()) {
//                $this->tabs['foreign']['active'] = false;
//            }
//        }
        // $this->LinkedEntityTypes = EntityTypeRepository::getLinkedEntityTypes($tenantId);

        // $this->linkedEntityTypeIDs = $this->LinkedEntityTypes
        //     ->pluck('id', 'id')->toArray();

        // if ($this->LinkedEntityTypes->isEmpty()) {
        //     $this->tabs['linked']['active'] = false;
        // }
    } // _initEntityTypes()


    /**
     *
     * @version     1.0.0 / 2025-05-25
     * @author      Wassilios Meletiadis <wassilios.meletiadis@bplan-solutions.de>
     */
    protected function _initTenants(): void
    {
        $Tenants = TenantRepository::getAll(orderBy: 'identifier', withInactive: true);

        $this->tenants = $Tenants->pluck('identifier', 'id')
            ->toArray();

    } // _initTenants()


    /**
     *
     * @version     1.0.0 / 2025-05-25
     * @author      Wassilios Meletiadis <wassilios.meletiadis@bplan-solutions.de>
     */
    public function mount(): void
    {
        parent::mount();

        $this->_initEntityTypes();
        $this->_initTenants();

    } // mount()


/* +++ CLASS METHODS +++ ++++++++++++++++++++++++++++++++++++++++++++++++++++ */


} // class Grid extends BaseGrid {}
