<?php
/**
 * Model Class
 *
 * @version     1.0.$Revision:$
 * @version     SVN: $Id:$
 * @generated   2025-05-25 00:38:52
 * @package     bplan-base/globals
 * @subpackage  Models
 * @author      Emilio Cannarozzo <emilio.cannarozzo@bplan-solutions.de>
 * @author      Wassilios Meletiadis <wassilios.meletiadis@bplan-solutions.de>
 * @copyright   Copyright (C) 2025 bplan-solutions GmbH & Co. KG <https://www.bplan-solutions.de/>
 * /Δ\
 */

namespace BplanBase\Globals\Models;


use BplanBase\Globals\Observers\TenantExternalSystemObserver;
use BplanBase\Globals\Scopes\TenantScope;
use BplanBase\Globals\Traits\HasActiveScope;
use BplanBase\Globals\Traits\HasOrderedScope;
use Illuminate\Database\Eloquent\Attributes\ObservedBy;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Relations\BelongsTo;
use Illuminate\Database\Eloquent\SoftDeletes;


/**
 * Model Class
 *
 * @version     1.5.0 / 2025-05-31
 * @author      Emilio Cannarozzo <emilio.cannarozzo@bplan-solutions.de>
 * @author      Wassilios Meletiadis <wassilios.meletiadis@bplan-solutions.de>
 */
#[ObservedBy([TenantExternalSystemObserver::class])]
class TenantExternalSystem extends Model
{


/* +++ TRAITS +++ +++++++++++++++++++++++++++++++++++++++++++++++++++++++++++ */


    use HasActiveScope;
    use HasOrderedScope;
    use SoftDeletes;


/* +++ CLASS CONSTANTS +++ ++++++++++++++++++++++++++++++++++++++++++++++++++ */


/* +++ OBJECT MEMBERS +++ +++++++++++++++++++++++++++++++++++++++++++++++++++ */


    /**
     * The accessors to append to the model's array form.
     *
     * @var         array<int, string> $appends
     *
     * @version     1.0.0 / 2025-05-25
     */
    protected $appends = [];


    /**
     * @var         array<string, string> $casts
     *
     * @version     1.0.0 / 2025-05-25
     */
    protected $casts = [
        'active'          => 'boolean',
        'config_settings' => 'object',
        'created_at'      => 'datetime',
        'deleted_at'      => 'datetime',
        'synchronize'     => 'boolean',
        'updated_at'      => 'datetime',
    ];


    /**
     * The attributes that are mass assignable.
     *
     * @var         array<int, string> $fillable
     *
     * @version     2.0.0 / 2025-05-31
     */
    protected $fillable = [
        'active',
        'config_settings',
        'external_system_id',
        'identifier',
        'key_index',
        'label',
        'synchronize',
    ];


    /**
     * The attributes that aren't mass assignable.
     *
     * @var         array<int, string> $guarded
     *
     * @version     2.0.0 / 2025-05-31
     */
    protected $guarded = [
        'created_at',
        'deleted_at',
        'tenant_id',
        'updated_at',
        'uuid',
    ];


    /**
     * The attributes that should be hidden for serialization.
     *
     * @var         array<int, string> $hidden
     *
     * @version     1.0.0 / 2025-05-25
     */
    protected $hidden = [];


    /**
     * The table associated with the model.
     *
     * @var         string $table
     */
    protected $table = 'tenant_external_systems';


    /**
     * Indicates if the model should be timestamped.
     *
     * @var         bool $timestamps
     */
    public $timestamps = true;


/* +++ CLASS MEMBERS +++ ++++++++++++++++++++++++++++++++++++++++++++++++++++ */


/* +++ OBJECT METHODS +++ +++++++++++++++++++++++++++++++++++++++++++++++++++ */


    /**
     *
     * @return      BelongsTo
     *
     * @version     1.0.0 / 2025-05-25
     * @author      Emilio Cannarozzo <emilio.cannarozzo@bplan-solutions.de>
     * @author      Wassilios Meletiadis <wassilios.meletiadis@bplan-solutions.de>
     */
    public function externalSystem(): BelongsTo
    {
        return $this->belongsTo(ExternalSystem::class, 'external_system_id');

    } // externalSystem()


    /**
     *
     * @return      BelongsTo
     *
     * @version     1.0.0 / 2025-05-25
     * @author      Emilio Cannarozzo <emilio.cannarozzo@bplan-solutions.de>
     * @author      Wassilios Meletiadis <wassilios.meletiadis@bplan-solutions.de>
     */
    public function tenant(): BelongsTo
    {
        return $this->belongsTo(Tenant::class, 'tenant_id');

    } // tenant()


/* +++ CLASS METHODS +++ ++++++++++++++++++++++++++++++++++++++++++++++++++++ */


    /**
     *
     * @return      void
     *
     * @version     1.0.0 / 2025-05-20
     * @author      Wassilios Meletiadis <wassilios.meletiadis@bplan-solutions.de>
     */
    protected static function booted(): void
    {
        static::addGlobalScope(new TenantScope());

    } // booted()


} // class TenantExternalSystem extends Model {}
