# Project Setup

This guide describes how to set up a Laravel project as the basis for a new project.

## Installing the base

The basic requirement for all projects is Laravel with Jetstream and Livewire. To set up these components, the following commands must be executed in sequence:
```bash

composer create-project laravel/laravel #example-app#

cd #example-app#

composer require laravel/jetstream

php artisan jetstream:install livewire --dark

```
The character string `#example-app#` must be replaced by the desired directory name.

The last command, `php artisan jetstream:install livewire --dark`, will display the following message:
```bash
New database migrations were added. Would you like to re-run your migrations? (yes/no) [yes]
```
This question should be answered with “**no**”.

## Install Globals package

The globals package provides models, repositories, service classes, middlewares, traits and much more to supplement the base.

As the package is not in a public repository, the repository must be registered in the first installation step. To avoid having to register a separate repository for each private package, selected packages are made available via a central repository:
```bash
composer config repositories.bplan/composer-packages composer https://satis.bplan.solutions
```

It may happen that an error message is displayed that criticizes the structure of the command. In this case, the `composer.json` can also be extended manually as follows:

```json

    "repositories": {
        "bplan/composer-packages": {
            "type": "composer",
            "url": "https://satis.bplan.solutions"
        }
    }
    
```

The package can then be installed as usual:
```bash
composer require bplan-base/globals
```

After the installation, the setup of the Globals package can be started:
```bash
php artisan globals:setup
```
Executing the command performs the following tasks in the project directory:

* Replacing some default files.
* Adding new files.
* Extending the `.env` file.
* Creating the storage link.
* Installing and setting up the “wikimedia/composer-merge-plugin” package.

## Code Generator

Using the Globals package for a new project requires the installation of the Code Generator.

The Code Generator uses specially prepared migrations to automatically generate classes based on the table schema defined in it and an extended configuration.

The package should be installed as a dev dependency:
```bash
composer require bplan-base/laravel-code-generator --dev
```
In this way, it will not be installed later when the project is set up on a production system, provided that the installation is executed there with the `--no-dev` parameter. To be absolutely sure that the Code Generator is not inadvertently installed in a production environment, it can alternatively be registered in the external Composer configuration `composer.local.json`.

To activate the code generator, the following setting must be made in the `.env` file:
```toml
CODE_GENERATOR_ACTIVE = true
```

During development, the Code Generator may not be able to complete its work due to an error that occurs during the execution of the migration. It may then not be possible to run the migration again because the required relations have not been created.
In this case, the following configuration setting can be entered in the `.env` file:
```toml
CODE_GENERATOR_SKIP_ROUTING = true
```
Both settings are automatically added to the `.env` file by the setup.

The use of the code generator is described in the associated `README` file.

Finally, the migrations and seeds can be executed:
```bash
php artisan migrate:fresh --seed
```

## Dev packages

When setting up the globals package, the file `composer.local.json.in` is created in the root directory of the project. This is the template file that must be renamed or copied to `composer.local.conf` for use. It is then loaded automatically when `composer install` or `composer update` is executed.

Packages that are not or should not be part of the project can be registered in this file. This is useful, for example, if a package is only required for development or if a package is to be developed that needs to be loaded from the local hard disk.
Example:
```json
{
    "require": {
        "vendor/package": "@dev"
    },
    "require-dev": {
        "bplan-base/laravel-code-generator": "@dev"
    },
    "repositories": [
        {
            "name": "vendor/package",
            "type": "path",
            "url": "/local/path/to/vendor/package",
            "options": {
                "symlink": true
            }
        },
        {
            "name": "bplan-base/laravel-code-generator",
            "type": "path",
            "url": "/local/path/to/bplan-base/laravel-code-generator",
            "options": {
                "symlink": true
            }
        }
    ]
}

```

**Important:**
The file `composer.local.conf` must not be versioned.
