<?php
/**
 * Migration Class
 *
 * @version     1.0.$Revision:$
 * @version     SVN: $Id:$
 * @package     bplan-base/globals
 * @subpackage  Migrations
 * @author      Emilio Cannarozzo <emilio.cannarozzo@bplan-solutions.de>
 * @author      Wassilios Meletiadis <wassilios.meletiadis@bplan-solutions.de>
 * @copyright   Copyright (C) 2025 bplan-solutions GmbH & Co. KG <https://www.bplan-solutions.de/>
 * /Δ\
 */


use BplanBase\CodeGenerator\Loaders\CodeGenerator;
use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;


/**
 * Migration Class
 *
 * @author      Emilio Cannarozzo <emilio.cannarozzo@bplan-solutions.de>
 * @author      Wassilios Meletiadis <wassilios.meletiadis@bplan-solutions.de>
 */
return new class extends Migration
{

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('tenant_locales');

    } // down()


    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('tenant_locales', function (Blueprint $Table) {
            $Table->id();
            $Table->uuid('uuid');
            $Table->boolean('active')->default(1);

            $Table->timestamp('created_at');

            $Table->unsignedInteger('key_index')->default(1);    // @todo   Default ggf. entfernen. Verwendung prüfen und ggf. das ganze Feld entfernen.
            $Table->string('locale', 5);
            $Table->boolean('main')->default(0);
            $Table->foreignId('tenant_id')->constrained(table: 'tenants', indexName: 'tenant_locales_FK_tenant_id');

            $Table->index('tenant_id', 'tenant_locales_FKI_tenant_id');
            /*
            **  Der KeyIndex muss in Kombination mit der Tenant-ID immer eineindeutig sein. */
            $Table->unique(['key_index', 'tenant_id'], 'tenant_locales_UKI_key_index_tenant_id');
            $Table->unique('uuid',                     'tenant_locales_UKI_uuid');

            new CodeGenerator($Table, [
                'columns' => [
                    'active' => [
                        'sortable' => true,
                    ],
                    'tenant_id' => [
                        'guarded' => true,
                        'reverseRelationName' => 'locales',
                        'sortable' => true,
                    ],
                ],
                'exclude' => [
                    'livewire.index',
                    'livewire.modal.create',
                    'livewire.modal.edit',
                ],
                'extends' => [
                    'laravel.model' => 'BplanBase\\Globals\\Foundation\\Database\\Eloquent\\Models\\BaseModel',
                ],
                'indexQueries' => [
                    'terminal' => '$Query->where(\'active\', \'=\', 1)',
                ],
                'routing' => [
                    'terminal' => 'readOnly',
                ],
                'traits' => [
                    'laravel.model' => [
                        'BplanBase\\Globals\Traits\\HasActiveScope',
                        'BplanBase\\Globals\Traits\\HasOrderedScope',
                    ],
                ],
                'uses' => [
                    'laravel.model' => [
                        'BplanBase\\Globals\\Scopes\\TenantScope'
                    ]
                ],

            ]);

        });
    } // up()

};
