<?php
/**
 * Migration Class
 *
 * @version     1.0.$Revision:$
 * @version     SVN: $Id:$
 * @package     bplan-base/globals
 * @subpackage  Migrations
 * @author      Emilio Cannarozzo <emilio.cannarozzo@bplan-solutions.de>
 * @author      Wassilios Meletiadis <wassilios.meletiadis@bplan-solutions.de>
 * @copyright   Copyright (C) 2025 bplan-solutions GmbH & Co. KG <https://www.bplan-solutions.de/>
 * /Δ\
 */


use BplanBase\CodeGenerator\Loaders\CodeGenerator;
use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;


/**
 * Migration Class
 *
 * @author      Emilio Cannarozzo <emilio.cannarozzo@bplan-solutions.de>
 * @author      Wassilios Meletiadis <wassilios.meletiadis@bplan-solutions.de>
 */
return new class extends Migration
{

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('tenant_external_systems');

    } // down()


    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('tenant_external_systems', function (Blueprint $Table) {
            $Table->id();
            $Table->uuid('uuid');
            $Table->boolean('active')->default(1);

            $Table->timestamp('created_at');
            $Table->softDeletes('deleted_at');
            $Table->timestamp('updated_at');

            $Table->json('config_settings')->nullable();
            $Table->foreignId('external_system_id')->nullable()->constrained(table: 'external_systems', indexName: 'tenant_external_systems_FK_external_system_id');
            $Table->string('identifier', 20);
            $Table->unsignedTinyInteger('key_index')->default(1);    // @todo   Default ggf. entfernen
            $Table->string('label', 30);
            $Table->boolean('synchronize')->default(0);
            $Table->foreignId('tenant_id')->nullable()->constrained(table: 'tenants', indexName: 'tenant_external_systems_FK_tenant_id');

            $Table->index('external_system_id', 'tenant_external_systems_FKI_external_system_id');
            $Table->index('tenant_id',          'tenant_external_systems_FKI_tenant_id');
            $Table->unique('uuid',              'tenant_external_systems_UKI_uuid');

            new CodeGenerator($Table, [
                'columns' => [
                    'uuid' => [
                        'guarded' => true,
                    ],
                    'active' => [
                        'sortable' => true,
                    ],
                    'key_index' => [
                        'sortable' => true,
                    ],
                    'label' => [
                        'sortable' => true,
                    ],
                    'tenant_id' => [
                        'guarded' => true,
                        'reverseRelationName' => 'external-systems',
                        'sortable' => true,
                    ],
                ],
                'extends' => [
                    'laravel.model' => 'BplanBase\\Globals\\Foundation\\Database\\Eloquent\\Models\\BaseModel',
                ],
                'indexQueries' => [
                    'terminal' => '$Query->where(\'active\', \'=\', 1)',
                ],
                'routing' => [
                    'terminal' => 'readOnly',
                ],
                'traits' => [
                    'laravel.model' => [
                        'BplanBase\\Globals\Traits\\HasActiveScope',
                        'BplanBase\\Globals\Traits\\HasOrderedScope',
                    ],
                ],
                'uses' => [
                    'laravel.model' => [
                        'BplanBase\\Globals\\Scopes\\TenantScope'
                    ]
                ],

            ]);

        });
    } // up()

};
